// Generated by delombok at Mon Nov 26 08:20:55 UTC 2018
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import lombok.*;

public class TransactionDetail implements Serializable {
  private static final long serialVersionUID = 658273092293607458L;
  private Long networkId;
  private String hash;
  private String contractAddress;
  private String contractMethodName;
  private boolean pending;
  private boolean isAdminOperation;
  private String from;
  private String to;
  private String label;
  private String message;
  private double value;
  private double contractAmount;
  private long timestamp;

  public static TransactionDetail fromStoredValue(String storedTransactionDetails) {
    TransactionDetail transactionMessage = new TransactionDetail();
    if (StringUtils.isNotBlank(storedTransactionDetails)) {
      String[] transactionDetailsArray = storedTransactionDetails.split(";");
      transactionMessage.setHash(transactionDetailsArray[0]);
      transactionMessage.setLabel(transactionDetailsArray.length > 1 ? decode(transactionDetailsArray[1]) : null);
      transactionMessage.setMessage(transactionDetailsArray.length > 2 ? decode(transactionDetailsArray[2]) : null);
    }
    return transactionMessage;
  }

  /**
   * Determine the value to store on address transactions list if sender,
   * include label, else omit it.
   * 
   * @param sender
   * @return
   */
  public String getToStoreValue(boolean sender) {
    return hash + ";" + (sender ? encode(label) : "") + ";" + encode(message);
  }

  public String toJSONString() {
    return toJSONObject().toString();
  }

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      if (networkId != null && networkId > 0) {
        jsonObject.put("networkId", networkId);
      }
      jsonObject.put("hash", hash);
      if (StringUtils.isNotBlank(contractAddress)) {
        jsonObject.put("contractAddress", contractAddress);
      }
      if (StringUtils.isNotBlank(contractMethodName)) {
        jsonObject.put("contractMethodName", contractMethodName);
      }
      if (StringUtils.isNotBlank(from)) {
        jsonObject.put("from", from);
      }
      if (StringUtils.isNotBlank(to)) {
        jsonObject.put("to", to);
      }
      jsonObject.put("label", label);
      jsonObject.put("message", message);
      if (value > 0) {
        jsonObject.put("value", value);
      }
      if (contractAmount > 0) {
        jsonObject.put("contractAmount", contractAmount);
      }
      if (timestamp > 0) {
        jsonObject.put("timestamp", timestamp);
      }
      if (pending) {
        jsonObject.put("pending", pending);
      }
      if (isAdminOperation) {
        jsonObject.put("isAdminOperation", isAdminOperation);
      }
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  private static String encode(String content) {
    try {
      return StringUtils.isBlank(content) ? "" : URLEncoder.encode(content.trim(), "UTF-8");
    } catch (Exception e) {
      return content;
    }
  }

  private static String decode(String content) {
    try {
      return StringUtils.isBlank(content) ? "" : URLDecoder.decode(content.trim(), "UTF-8");
    } catch (Exception e) {
      return content;
    }
  }

  @java.lang.SuppressWarnings("all")
  public Long getNetworkId() {
    return this.networkId;
  }

  @java.lang.SuppressWarnings("all")
  public String getHash() {
    return this.hash;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractAddress() {
    return this.contractAddress;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractMethodName() {
    return this.contractMethodName;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isPending() {
    return this.pending;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isAdminOperation() {
    return this.isAdminOperation;
  }

  @java.lang.SuppressWarnings("all")
  public String getFrom() {
    return this.from;
  }

  @java.lang.SuppressWarnings("all")
  public String getTo() {
    return this.to;
  }

  @java.lang.SuppressWarnings("all")
  public String getLabel() {
    return this.label;
  }

  @java.lang.SuppressWarnings("all")
  public String getMessage() {
    return this.message;
  }

  @java.lang.SuppressWarnings("all")
  public double getValue() {
    return this.value;
  }

  @java.lang.SuppressWarnings("all")
  public double getContractAmount() {
    return this.contractAmount;
  }

  @java.lang.SuppressWarnings("all")
  public long getTimestamp() {
    return this.timestamp;
  }

  @java.lang.SuppressWarnings("all")
  public void setNetworkId(final Long networkId) {
    this.networkId = networkId;
  }

  @java.lang.SuppressWarnings("all")
  public void setHash(final String hash) {
    this.hash = hash;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractAddress(final String contractAddress) {
    this.contractAddress = contractAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractMethodName(final String contractMethodName) {
    this.contractMethodName = contractMethodName;
  }

  @java.lang.SuppressWarnings("all")
  public void setPending(final boolean pending) {
    this.pending = pending;
  }

  @java.lang.SuppressWarnings("all")
  public void setAdminOperation(final boolean isAdminOperation) {
    this.isAdminOperation = isAdminOperation;
  }

  @java.lang.SuppressWarnings("all")
  public void setFrom(final String from) {
    this.from = from;
  }

  @java.lang.SuppressWarnings("all")
  public void setTo(final String to) {
    this.to = to;
  }

  @java.lang.SuppressWarnings("all")
  public void setLabel(final String label) {
    this.label = label;
  }

  @java.lang.SuppressWarnings("all")
  public void setMessage(final String message) {
    this.message = message;
  }

  @java.lang.SuppressWarnings("all")
  public void setValue(final double value) {
    this.value = value;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractAmount(final double contractAmount) {
    this.contractAmount = contractAmount;
  }

  @java.lang.SuppressWarnings("all")
  public void setTimestamp(final long timestamp) {
    this.timestamp = timestamp;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TransactionDetail)) return false;
    final TransactionDetail other = (TransactionDetail) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$networkId = this.getNetworkId();
    final java.lang.Object other$networkId = other.getNetworkId();
    if (this$networkId == null ? other$networkId != null : !this$networkId.equals(other$networkId)) return false;
    final java.lang.Object this$hash = this.getHash();
    final java.lang.Object other$hash = other.getHash();
    if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
    final java.lang.Object this$contractAddress = this.getContractAddress();
    final java.lang.Object other$contractAddress = other.getContractAddress();
    if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) return false;
    final java.lang.Object this$contractMethodName = this.getContractMethodName();
    final java.lang.Object other$contractMethodName = other.getContractMethodName();
    if (this$contractMethodName == null ? other$contractMethodName != null : !this$contractMethodName.equals(other$contractMethodName)) return false;
    if (this.isPending() != other.isPending()) return false;
    if (this.isAdminOperation() != other.isAdminOperation()) return false;
    final java.lang.Object this$from = this.getFrom();
    final java.lang.Object other$from = other.getFrom();
    if (this$from == null ? other$from != null : !this$from.equals(other$from)) return false;
    final java.lang.Object this$to = this.getTo();
    final java.lang.Object other$to = other.getTo();
    if (this$to == null ? other$to != null : !this$to.equals(other$to)) return false;
    final java.lang.Object this$label = this.getLabel();
    final java.lang.Object other$label = other.getLabel();
    if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
    final java.lang.Object this$message = this.getMessage();
    final java.lang.Object other$message = other.getMessage();
    if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
    if (java.lang.Double.compare(this.getValue(), other.getValue()) != 0) return false;
    if (java.lang.Double.compare(this.getContractAmount(), other.getContractAmount()) != 0) return false;
    if (this.getTimestamp() != other.getTimestamp()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TransactionDetail;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $networkId = this.getNetworkId();
    result = result * PRIME + ($networkId == null ? 43 : $networkId.hashCode());
    final java.lang.Object $hash = this.getHash();
    result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
    final java.lang.Object $contractAddress = this.getContractAddress();
    result = result * PRIME + ($contractAddress == null ? 43 : $contractAddress.hashCode());
    final java.lang.Object $contractMethodName = this.getContractMethodName();
    result = result * PRIME + ($contractMethodName == null ? 43 : $contractMethodName.hashCode());
    result = result * PRIME + (this.isPending() ? 79 : 97);
    result = result * PRIME + (this.isAdminOperation() ? 79 : 97);
    final java.lang.Object $from = this.getFrom();
    result = result * PRIME + ($from == null ? 43 : $from.hashCode());
    final java.lang.Object $to = this.getTo();
    result = result * PRIME + ($to == null ? 43 : $to.hashCode());
    final java.lang.Object $label = this.getLabel();
    result = result * PRIME + ($label == null ? 43 : $label.hashCode());
    final java.lang.Object $message = this.getMessage();
    result = result * PRIME + ($message == null ? 43 : $message.hashCode());
    final long $value = java.lang.Double.doubleToLongBits(this.getValue());
    result = result * PRIME + (int) ($value >>> 32 ^ $value);
    final long $contractAmount = java.lang.Double.doubleToLongBits(this.getContractAmount());
    result = result * PRIME + (int) ($contractAmount >>> 32 ^ $contractAmount);
    final long $timestamp = this.getTimestamp();
    result = result * PRIME + (int) ($timestamp >>> 32 ^ $timestamp);
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public TransactionDetail(final Long networkId, final String hash, final String contractAddress, final String contractMethodName, final boolean pending, final boolean isAdminOperation, final String from, final String to, final String label, final String message, final double value, final double contractAmount, final long timestamp) {
    this.networkId = networkId;
    this.hash = hash;
    this.contractAddress = contractAddress;
    this.contractMethodName = contractMethodName;
    this.pending = pending;
    this.isAdminOperation = isAdminOperation;
    this.from = from;
    this.to = to;
    this.label = label;
    this.message = message;
    this.value = value;
    this.contractAmount = contractAmount;
    this.timestamp = timestamp;
  }

  @java.lang.SuppressWarnings("all")
  public TransactionDetail() {
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "TransactionDetail(networkId=" + this.getNetworkId() + ", hash=" + this.getHash() + ", contractAddress=" + this.getContractAddress() + ", contractMethodName=" + this.getContractMethodName() + ", pending=" + this.isPending() + ", isAdminOperation=" + this.isAdminOperation() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", label=" + this.getLabel() + ", message=" + this.getMessage() + ", value=" + this.getValue() + ", contractAmount=" + this.getContractAmount() + ", timestamp=" + this.getTimestamp() + ")";
  }
}
