/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.notification.plugin;

import java.util.List;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;

public class WalletReceiverNotificationPlugin
extends BaseNotificationPlugin {
    public WalletReceiverNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return TransactionStatus.RECEIVER.getNotificationId();
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        AccountDetail senderAccountDetail = (AccountDetail)ctx.value(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        AccountDetail receiverAccountDetail = (AccountDetail)ctx.value(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        String symbol = (String)ctx.value(Utils.SYMBOL_PARAMETER);
        double amount = (Double)ctx.value(Utils.AMOUNT_PARAMETER);
        String message = (String)ctx.value(Utils.MESSAGE_PARAMETER);
        String hash = (String)ctx.value(Utils.HASH_PARAMETER);
        List<String> toList = Utils.getNotificationReceiversUsers(receiverAccountDetail, senderAccountDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(toList).with("account_type", receiverAccountDetail.getType()).with("amount", String.valueOf(amount)).with("symbol", symbol).with("message", message).with("hash", hash).with("avatar", CommonsUtils.getCurrentDomain() + senderAccountDetail.getAvatar()).with("senderUrl", Utils.getPermanentLink(senderAccountDetail)).with("receiverUrl", Utils.getPermanentLink(receiverAccountDetail)).with("sender", senderAccountDetail.getName()).with("receiver", receiverAccountDetail.getName()).key(this.getKey()).end();
    }
}

