// Generated by delombok at Mon Dec 10 15:15:40 UTC 2018
package org.exoplatform.addon.ethereum.wallet.ext.kudos.model;

import static org.exoplatform.addon.ethereum.wallet.service.utils.Utils.decodeString;
import static org.exoplatform.addon.ethereum.wallet.service.utils.Utils.encodeString;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import lombok.*;

public class KudosTransaction implements Serializable {
  private static final long serialVersionUID = 658273092293607458L;
  private Long networkId;
  private String periodType;
  private long startDateInSeconds;
  private String hash;
  private String receiverType;
  private String receiverId;
  private String receiverIdentityId;
  private String tokensAmountSent;

  public static KudosTransaction fromStoredValue(String storedTransactionDetails) {
    KudosTransaction transactionMessage = new KudosTransaction();
    if (StringUtils.isNotBlank(storedTransactionDetails)) {
      String[] transactionDetailsArray = storedTransactionDetails.split(";");
      transactionMessage.setHash(transactionDetailsArray[0]);
      transactionMessage.setReceiverType(transactionDetailsArray.length > 1 ? decodeString(transactionDetailsArray[1]) : null);
      transactionMessage.setReceiverId(transactionDetailsArray.length > 2 ? decodeString(transactionDetailsArray[2]) : null);
      transactionMessage.setTokensAmountSent(transactionDetailsArray.length > 3 ? decodeString(transactionDetailsArray[3]) : null);
      transactionMessage.setReceiverIdentityId(transactionDetailsArray.length > 4 ? decodeString(transactionDetailsArray[4]) : null);
    }
    return transactionMessage;
  }

  /**
   * Determine the value to store on transactions list.
   * 
   * @return
   */
  public String getToStoreValue() {
    if (StringUtils.isBlank(receiverType)) {
      throw new IllegalStateException("receiverType is mandatory");
    }
    if (StringUtils.isBlank(receiverId)) {
      throw new IllegalStateException("receiverId is mandatory");
    }
    return hash + ";" + encodeString(receiverType) + ";" + encodeString(receiverId) + ";" + encodeString(tokensAmountSent) + ";" + receiverIdentityId;
  }

  public String toJSONString() {
    return toJSONObject().toString();
  }

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      if (networkId != null && networkId > 0) {
        jsonObject.put("networkId", networkId);
      }
      if (StringUtils.isNotBlank(hash)) {
        jsonObject.put("hash", hash);
      }
      if (StringUtils.isNotBlank(receiverType)) {
        jsonObject.put("receiverType", receiverType);
      }
      if (StringUtils.isNotBlank(receiverId)) {
        jsonObject.put("receiverId", receiverId);
      }
      if (StringUtils.isNotBlank(receiverIdentityId)) {
        jsonObject.put("receiverIdentityId", receiverIdentityId);
      }
      if (StringUtils.isNotBlank(tokensAmountSent)) {
        jsonObject.put("tokensAmountSent", tokensAmountSent);
      }
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null || !(obj instanceof KudosTransaction)) {
      return false;
    }
    return StringUtils.equalsIgnoreCase(hash, ((KudosTransaction) obj).getHash());
  }

  @java.lang.SuppressWarnings("all")
  public Long getNetworkId() {
    return this.networkId;
  }

  @java.lang.SuppressWarnings("all")
  public String getPeriodType() {
    return this.periodType;
  }

  @java.lang.SuppressWarnings("all")
  public long getStartDateInSeconds() {
    return this.startDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public String getHash() {
    return this.hash;
  }

  @java.lang.SuppressWarnings("all")
  public String getReceiverType() {
    return this.receiverType;
  }

  @java.lang.SuppressWarnings("all")
  public String getReceiverId() {
    return this.receiverId;
  }

  @java.lang.SuppressWarnings("all")
  public String getReceiverIdentityId() {
    return this.receiverIdentityId;
  }

  @java.lang.SuppressWarnings("all")
  public String getTokensAmountSent() {
    return this.tokensAmountSent;
  }

  @java.lang.SuppressWarnings("all")
  public void setNetworkId(final Long networkId) {
    this.networkId = networkId;
  }

  @java.lang.SuppressWarnings("all")
  public void setPeriodType(final String periodType) {
    this.periodType = periodType;
  }

  @java.lang.SuppressWarnings("all")
  public void setStartDateInSeconds(final long startDateInSeconds) {
    this.startDateInSeconds = startDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public void setHash(final String hash) {
    this.hash = hash;
  }

  @java.lang.SuppressWarnings("all")
  public void setReceiverType(final String receiverType) {
    this.receiverType = receiverType;
  }

  @java.lang.SuppressWarnings("all")
  public void setReceiverId(final String receiverId) {
    this.receiverId = receiverId;
  }

  @java.lang.SuppressWarnings("all")
  public void setReceiverIdentityId(final String receiverIdentityId) {
    this.receiverIdentityId = receiverIdentityId;
  }

  @java.lang.SuppressWarnings("all")
  public void setTokensAmountSent(final String tokensAmountSent) {
    this.tokensAmountSent = tokensAmountSent;
  }

  @java.lang.SuppressWarnings("all")
  public KudosTransaction(final Long networkId, final String periodType, final long startDateInSeconds, final String hash, final String receiverType, final String receiverId, final String receiverIdentityId, final String tokensAmountSent) {
    this.networkId = networkId;
    this.periodType = periodType;
    this.startDateInSeconds = startDateInSeconds;
    this.hash = hash;
    this.receiverType = receiverType;
    this.receiverId = receiverId;
    this.receiverIdentityId = receiverIdentityId;
    this.tokensAmountSent = tokensAmountSent;
  }

  @java.lang.SuppressWarnings("all")
  public KudosTransaction() {
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "KudosTransaction(networkId=" + this.getNetworkId() + ", periodType=" + this.getPeriodType() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", hash=" + this.getHash() + ", receiverType=" + this.getReceiverType() + ", receiverId=" + this.getReceiverId() + ", receiverIdentityId=" + this.getReceiverIdentityId() + ", tokensAmountSent=" + this.getTokensAmountSent() + ")";
  }
}
