/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.ext.gamification.model;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationPeriod;
import org.exoplatform.addon.ethereum.wallet.service.utils.GamificationUtils;

public enum GamificationPeriodType {
    WEEK,
    MONTH,
    QUARTER,
    SEMESTER,
    YEAR;

    public static final GamificationPeriodType DEFAULT;

    public GamificationPeriod getPeriodOfTime(LocalDateTime localDateTime) {
        GamificationPeriod gamificationPeriod = new GamificationPeriod();
        YearMonth yearMonth = YearMonth.from(localDateTime);
        switch (this) {
            case WEEK: {
                LocalDateTime firstDayOfThisWeek = localDateTime.with(DayOfWeek.MONDAY);
                LocalDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                gamificationPeriod.setStartDateInSeconds(GamificationUtils.timeToSeconds(firstDayOfThisWeek));
                gamificationPeriod.setEndDateInSeconds(GamificationUtils.timeToSeconds(firstDayOfNextWeek));
                break;
            }
            case MONTH: {
                YearMonth currentMonth = yearMonth;
                YearMonth nextMonth = currentMonth.plusMonths(1L);
                gamificationPeriod.setStartDateInSeconds(GamificationUtils.timeToSeconds(currentMonth.atDay(1).atStartOfDay()));
                gamificationPeriod.setEndDateInSeconds(GamificationUtils.timeToSeconds(nextMonth.atDay(1).atStartOfDay()));
                break;
            }
            case QUARTER: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                gamificationPeriod.setStartDateInSeconds(GamificationUtils.timeToSeconds(startQuarterMonth.atDay(1).atStartOfDay()));
                gamificationPeriod.setEndDateInSeconds(GamificationUtils.timeToSeconds(endQuarterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case SEMESTER: {
                int monthSemesterIndex = (yearMonth.getMonthValue() - 1) / 6 * 6 + 1;
                YearMonth startSemesterMonth = YearMonth.of(yearMonth.getYear(), monthSemesterIndex);
                YearMonth endSemesterMonth = startSemesterMonth.plusMonths(6L);
                gamificationPeriod.setStartDateInSeconds(GamificationUtils.timeToSeconds(startSemesterMonth.atDay(1).atStartOfDay()));
                gamificationPeriod.setEndDateInSeconds(GamificationUtils.timeToSeconds(endSemesterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case YEAR: {
                gamificationPeriod.setStartDateInSeconds(GamificationUtils.timeToSeconds(Year.from(localDateTime).atDay(1).atStartOfDay()));
                gamificationPeriod.setEndDateInSeconds(GamificationUtils.timeToSeconds(Year.from(localDateTime).plusYears(1L).atDay(1).atStartOfDay()));
            }
        }
        return gamificationPeriod;
    }

    static {
        DEFAULT = MONTH;
    }
}

