// Generated by delombok at Sun Dec 23 18:42:09 UTC 2018
package org.exoplatform.addon.ethereum.wallet.ext.reward.model;

import java.time.LocalDateTime;
import org.json.JSONException;
import org.json.JSONObject;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import lombok.*;

public class RewardPeriod {
  private long startDateInSeconds;
  private long endDateInSeconds;

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put("startDateInSeconds", startDateInSeconds);
      jsonObject.put("endDateInSeconds", endDateInSeconds);
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public String toString() {
    return toJSONObject().toString();
  }

  public static RewardPeriod getCurrentPeriod(GamificationSettings gamificationSettings) {
    return getPeriodOfTime(gamificationSettings, LocalDateTime.now());
  }

  public static RewardPeriod getPeriodOfTime(GamificationSettings gamificationSettings, LocalDateTime localDateTime) {
    RewardPeriodType gamificationPeriodType = null;
    if (gamificationSettings == null || gamificationSettings.getPeriodType() == null) {
      gamificationPeriodType = RewardPeriodType.DEFAULT;
    } else {
      gamificationPeriodType = gamificationSettings.getPeriodType();
    }
    return gamificationPeriodType.getPeriodOfTime(localDateTime);
  }

  @java.lang.SuppressWarnings("all")
  public long getStartDateInSeconds() {
    return this.startDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public long getEndDateInSeconds() {
    return this.endDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public void setStartDateInSeconds(final long startDateInSeconds) {
    this.startDateInSeconds = startDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public void setEndDateInSeconds(final long endDateInSeconds) {
    this.endDateInSeconds = endDateInSeconds;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof RewardPeriod)) return false;
    final RewardPeriod other = (RewardPeriod) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getStartDateInSeconds() != other.getStartDateInSeconds()) return false;
    if (this.getEndDateInSeconds() != other.getEndDateInSeconds()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof RewardPeriod;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final long $startDateInSeconds = this.getStartDateInSeconds();
    result = result * PRIME + (int) ($startDateInSeconds >>> 32 ^ $startDateInSeconds);
    final long $endDateInSeconds = this.getEndDateInSeconds();
    result = result * PRIME + (int) ($endDateInSeconds >>> 32 ^ $endDateInSeconds);
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriod() {
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriod(final long startDateInSeconds, final long endDateInSeconds) {
    this.startDateInSeconds = startDateInSeconds;
    this.endDateInSeconds = endDateInSeconds;
  }
}
