/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.ext.gamification.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationRewardType;
import org.exoplatform.addon.ethereum.wallet.ext.reward.model.RewardPeriodType;
import org.exoplatform.addon.ethereum.wallet.service.utils.GamificationUtils;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class GamificationSettings
implements Serializable {
    public static final long serialVersionUID = 2416168589742260549L;
    private long threshold;
    private String contractAddress;
    private RewardPeriodType periodType = RewardPeriodType.DEFAULT;
    private GamificationRewardType rewardType = GamificationRewardType.FIXED;
    private double totalBudget;
    private double budgetPerMember;

    public static GamificationSettings fromString(String value) throws JsonException {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
        GamificationUtils.JSON_PARSER.parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
        return (GamificationSettings)ObjectBuilder.createObject(GamificationSettings.class, (JsonValue)jsonDefaultHandler.getJsonObject());
    }

    public String toStringToStore() {
        try {
            return GamificationUtils.JSON_GENERATOR.createJsonObject((Object)this).toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't transform current GamificationSettings to string", e);
        }
    }

    public long getThreshold() {
        return this.threshold;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public RewardPeriodType getPeriodType() {
        return this.periodType;
    }

    public GamificationRewardType getRewardType() {
        return this.rewardType;
    }

    public double getTotalBudget() {
        return this.totalBudget;
    }

    public double getBudgetPerMember() {
        return this.budgetPerMember;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setPeriodType(RewardPeriodType periodType) {
        this.periodType = periodType;
    }

    public void setRewardType(GamificationRewardType rewardType) {
        this.rewardType = rewardType;
    }

    public void setTotalBudget(double totalBudget) {
        this.totalBudget = totalBudget;
    }

    public void setBudgetPerMember(double budgetPerMember) {
        this.budgetPerMember = budgetPerMember;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GamificationSettings)) {
            return false;
        }
        GamificationSettings other = (GamificationSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        RewardPeriodType this$periodType = this.getPeriodType();
        RewardPeriodType other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !((Object)((Object)this$periodType)).equals((Object)other$periodType)) {
            return false;
        }
        GamificationRewardType this$rewardType = this.getRewardType();
        GamificationRewardType other$rewardType = other.getRewardType();
        if (this$rewardType == null ? other$rewardType != null : !((Object)((Object)this$rewardType)).equals((Object)other$rewardType)) {
            return false;
        }
        if (Double.compare(this.getTotalBudget(), other.getTotalBudget()) != 0) {
            return false;
        }
        return Double.compare(this.getBudgetPerMember(), other.getBudgetPerMember()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof GamificationSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threshold = this.getThreshold();
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        RewardPeriodType $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : ((Object)((Object)$periodType)).hashCode());
        GamificationRewardType $rewardType = this.getRewardType();
        result = result * 59 + ($rewardType == null ? 43 : ((Object)((Object)$rewardType)).hashCode());
        long $totalBudget = Double.doubleToLongBits(this.getTotalBudget());
        result = result * 59 + (int)($totalBudget >>> 32 ^ $totalBudget);
        long $budgetPerMember = Double.doubleToLongBits(this.getBudgetPerMember());
        result = result * 59 + (int)($budgetPerMember >>> 32 ^ $budgetPerMember);
        return result;
    }

    public String toString() {
        return "GamificationSettings(threshold=" + this.getThreshold() + ", contractAddress=" + this.getContractAddress() + ", periodType=" + (Object)((Object)this.getPeriodType()) + ", rewardType=" + (Object)((Object)this.getRewardType()) + ", totalBudget=" + this.getTotalBudget() + ", budgetPerMember=" + this.getBudgetPerMember() + ")";
    }
}

