/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class TransactionDetail
implements Serializable {
    private static final long serialVersionUID = 658273092293607458L;
    private Long networkId;
    private String hash;
    private String contractAddress;
    private String contractMethodName;
    private boolean pending;
    private boolean isAdminOperation;
    private String from;
    private String to;
    private String label;
    private String message;
    private double value;
    private double contractAmount;
    private long timestamp;

    public static TransactionDetail fromStoredValue(String storedTransactionDetails) {
        TransactionDetail transactionMessage = new TransactionDetail();
        if (StringUtils.isNotBlank((String)storedTransactionDetails)) {
            String[] transactionDetailsArray = storedTransactionDetails.split(";");
            transactionMessage.setHash(transactionDetailsArray[0]);
            transactionMessage.setLabel(transactionDetailsArray.length > 1 ? Utils.decodeString(transactionDetailsArray[1]) : null);
            transactionMessage.setMessage(transactionDetailsArray.length > 2 ? Utils.decodeString(transactionDetailsArray[2]) : null);
        }
        return transactionMessage;
    }

    public TransactionDetail copy() {
        return new TransactionDetail(this.networkId, this.hash, this.contractAddress, this.contractMethodName, this.pending, this.isAdminOperation, this.from, this.to, this.label, this.message, this.value, this.contractAmount, this.timestamp);
    }

    public String getToStoreValue(boolean sender) {
        return this.hash + ";" + (sender ? Utils.encodeString(this.label) : "") + ";" + Utils.encodeString(this.message);
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.networkId != null && this.networkId > 0L) {
                jsonObject.put("networkId", (Object)this.networkId);
            }
            jsonObject.put("hash", (Object)this.hash);
            if (StringUtils.isNotBlank((String)this.contractAddress)) {
                jsonObject.put("contractAddress", (Object)this.contractAddress);
            }
            if (StringUtils.isNotBlank((String)this.contractMethodName)) {
                jsonObject.put("contractMethodName", (Object)this.contractMethodName);
            }
            if (StringUtils.isNotBlank((String)this.from)) {
                jsonObject.put("from", (Object)this.from);
            }
            if (StringUtils.isNotBlank((String)this.to)) {
                jsonObject.put("to", (Object)this.to);
            }
            jsonObject.put("label", (Object)this.label);
            jsonObject.put("message", (Object)this.message);
            if (this.value > 0.0) {
                jsonObject.put("value", this.value);
            }
            if (this.contractAmount > 0.0) {
                jsonObject.put("contractAmount", this.contractAmount);
            }
            if (this.timestamp > 0L) {
                jsonObject.put("timestamp", this.timestamp);
            }
            if (this.pending) {
                jsonObject.put("pending", this.pending);
            }
            if (this.isAdminOperation) {
                jsonObject.put("isAdminOperation", this.isAdminOperation);
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public String getHash() {
        return this.hash;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getContractMethodName() {
        return this.contractMethodName;
    }

    public boolean isPending() {
        return this.pending;
    }

    public boolean isAdminOperation() {
        return this.isAdminOperation;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMessage() {
        return this.message;
    }

    public double getValue() {
        return this.value;
    }

    public double getContractAmount() {
        return this.contractAmount;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setContractMethodName(String contractMethodName) {
        this.contractMethodName = contractMethodName;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public void setAdminOperation(boolean isAdminOperation) {
        this.isAdminOperation = isAdminOperation;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setContractAmount(double contractAmount) {
        this.contractAmount = contractAmount;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDetail)) {
            return false;
        }
        TransactionDetail other = (TransactionDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$networkId = this.getNetworkId();
        Long other$networkId = other.getNetworkId();
        if (this$networkId == null ? other$networkId != null : !((Object)this$networkId).equals(other$networkId)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        String this$contractMethodName = this.getContractMethodName();
        String other$contractMethodName = other.getContractMethodName();
        if (this$contractMethodName == null ? other$contractMethodName != null : !this$contractMethodName.equals(other$contractMethodName)) {
            return false;
        }
        if (this.isPending() != other.isPending()) {
            return false;
        }
        if (this.isAdminOperation() != other.isAdminOperation()) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getContractAmount(), other.getContractAmount()) != 0) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $networkId = this.getNetworkId();
        result = result * 59 + ($networkId == null ? 43 : ((Object)$networkId).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        String $contractMethodName = this.getContractMethodName();
        result = result * 59 + ($contractMethodName == null ? 43 : $contractMethodName.hashCode());
        result = result * 59 + (this.isPending() ? 79 : 97);
        result = result * 59 + (this.isAdminOperation() ? 79 : 97);
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        long $contractAmount = Double.doubleToLongBits(this.getContractAmount());
        result = result * 59 + (int)($contractAmount >>> 32 ^ $contractAmount);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public TransactionDetail(Long networkId, String hash, String contractAddress, String contractMethodName, boolean pending, boolean isAdminOperation, String from, String to, String label, String message, double value, double contractAmount, long timestamp) {
        this.networkId = networkId;
        this.hash = hash;
        this.contractAddress = contractAddress;
        this.contractMethodName = contractMethodName;
        this.pending = pending;
        this.isAdminOperation = isAdminOperation;
        this.from = from;
        this.to = to;
        this.label = label;
        this.message = message;
        this.value = value;
        this.contractAmount = contractAmount;
        this.timestamp = timestamp;
    }

    public TransactionDetail() {
    }

    public String toString() {
        return "TransactionDetail(networkId=" + this.getNetworkId() + ", hash=" + this.getHash() + ", contractAddress=" + this.getContractAddress() + ", contractMethodName=" + this.getContractMethodName() + ", pending=" + this.isPending() + ", isAdminOperation=" + this.isAdminOperation() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", label=" + this.getLabel() + ", message=" + this.getMessage() + ", value=" + this.getValue() + ", contractAmount=" + this.getContractAmount() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

