/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import java.util.Map;
import java.util.Set;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class InitialFundsRequestListener
extends Listener<Object, AccountDetail> {
    private static final Log LOG = ExoLogger.getLogger(InitialFundsRequestListener.class);
    private EthereumWalletService ethereumWalletService;

    public void onEvent(Event<Object, AccountDetail> event) throws Exception {
        AccountDetail accountDetail = (AccountDetail)event.getData();
        if (accountDetail == null || !"user".equals(accountDetail.getType())) {
            return;
        }
        GlobalSettings settings = this.getEthereumWalletService().getSettings();
        Map<String, Double> initialFunds = settings.getInitialFunds();
        if (initialFunds == null || initialFunds.isEmpty() || settings.getFundsHolder() == null || settings.getFundsHolder().isEmpty() || accountDetail.getId() == null || settings.getFundsHolder().equals(accountDetail.getId())) {
            return;
        }
        Set<String> addresses = initialFunds.keySet();
        for (String address : addresses) {
            Double amount = initialFunds.get(address);
            if (amount == null || amount == 0.0) {
                LOG.info("Fund request amount is 0, thus no notification will be sent.", new Object[]{address});
                continue;
            }
            address = address.toLowerCase();
            FundsRequest request = new FundsRequest();
            if (!"ether".equalsIgnoreCase(address)) {
                if (!settings.getDefaultContractsToDisplay().contains(address)) {
                    LOG.warn("Can't find contract with address {}. No fund request notification will be sent.", new Object[]{address});
                    continue;
                }
                request.setContract(address);
            }
            request.setAmount(amount);
            request.setAddress(accountDetail.getAddress());
            request.setReceipient(settings.getFundsHolder());
            request.setReceipientType(settings.getFundsHolderType());
            request.setMessage(settings.getInitialFundsRequestMessage());
            try {
                this.getEthereumWalletService().requestFunds(request);
            }
            catch (Exception e) {
                LOG.error((Object)("Unknown error occurred while user '" + Utils.getCurrentUserId() + "' requesting funds for wallet of type '" + accountDetail.getType() + "' with id '" + accountDetail.getId() + "'"), (Throwable)e);
                throw e;
            }
        }
    }

    public EthereumWalletService getEthereumWalletService() {
        if (this.ethereumWalletService == null) {
            this.ethereumWalletService = (EthereumWalletService)CommonsUtils.getService(EthereumWalletService.class);
        }
        return this.ethereumWalletService;
    }
}

