/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationTeam;
import org.exoplatform.addon.ethereum.wallet.service.WalletGamificationService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/gamification")
public class WalletGamificationREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletGamificationREST.class);
    WalletGamificationService walletGamificationService;

    public WalletGamificationREST(WalletGamificationService walletGamificationService) {
        this.walletGamificationService = walletGamificationService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="settings")
    @RolesAllowed(value={"users"})
    public Response getSettings() {
        try {
            GamificationSettings settings = this.walletGamificationService.getSettings();
            return Response.ok((Object)(settings == null ? new GamificationSettings() : settings)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting gamification settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="teams")
    @RolesAllowed(value={"administrators"})
    public Response getTeams() {
        return Response.ok(this.walletGamificationService.getTeams()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="removeTeam")
    @RolesAllowed(value={"administrators"})
    public Response removeTeam(@QueryParam(value="id") Long id) {
        if (id == null || id == 0L) {
            return Response.status((int)400).build();
        }
        try {
            GamificationTeam team = this.walletGamificationService.removeTeam(id);
            LOG.info("{} removed Gamification pool {}", new Object[]{Utils.getCurrentUserId(), team.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error removing Gamification pool with id: " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="saveSettings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response saveSettings(GamificationSettings gamificationSettings) {
        if (gamificationSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            gamificationSettings = this.walletGamificationService.saveSettings(gamificationSettings);
            LOG.info("{} saved Gamification settings '{}'", new Object[]{Utils.getCurrentUserId(), gamificationSettings.toString()});
            return Response.ok((Object)gamificationSettings).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving Gamification settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="saveTeam")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response saveTeam(GamificationTeam gamificationTeam) {
        if (gamificationTeam == null) {
            LOG.warn((Object)"Bad request sent to server with empty team");
            return Response.status((int)400).build();
        }
        try {
            gamificationTeam = this.walletGamificationService.saveTeam(gamificationTeam);
            LOG.info("{} saved Gamification pool {}", new Object[]{Utils.getCurrentUserId(), gamificationTeam.getName()});
            return Response.ok((Object)gamificationTeam).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving Gamification pool", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

