/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.picocontainer.Startable;

public class EthereumWalletContractService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletContractService.class);
    private static final String ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE = "address parameter is mandatory";
    private ConfigurationManager configurationManager;
    private String contractAbiPath;
    private JSONArray contractAbi;
    private String contractBinaryPath;
    private String contractBinary;
    private SettingService settingService;

    public EthereumWalletContractService(ConfigurationManager configurationManager, SettingService settingService, InitParams params) {
        this.settingService = settingService;
        this.configurationManager = configurationManager;
        if (params.containsKey((Object)"contract.abi.path")) {
            this.contractAbiPath = params.getValueParam("contract.abi.path").getValue();
        }
        if (StringUtils.isBlank((String)this.contractAbiPath)) {
            LOG.warn((Object)"Contract ABI path is empty, thus no contract deployment is possible");
        }
        if (params.containsKey((Object)"contract.bin.path")) {
            this.contractBinaryPath = params.getValueParam("contract.bin.path").getValue();
        }
        if (StringUtils.isBlank((String)this.contractBinaryPath)) {
            LOG.warn((Object)"Contract BIN path is empty, thus no contract deployment is possible");
        }
    }

    public void start() {
        try {
            String contractAbiString = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractAbiPath));
            this.contractAbi = new JSONArray(contractAbiString);
            this.contractBinary = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractBinaryPath));
            if (!this.contractBinary.startsWith("0x")) {
                this.contractBinary = "0x" + this.contractBinary;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can't read ABI/BIN files content", (Throwable)e);
        }
    }

    public void stop() {
    }

    public boolean isContract(String address, long networkId) {
        return this.getContractDetail(address, networkId) != null;
    }

    public void saveContract(ContractDetail contractDetail) {
        if (StringUtils.isBlank((String)contractDetail.getAddress())) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() == 0L) {
            throw new IllegalArgumentException("networkId parameter is mandatory");
        }
        String defaultContractsParamKey = "WALLET_DEFAULT_CONTRACTS" + contractDetail.getNetworkId();
        String address = contractDetail.getAddress().toLowerCase();
        this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address + contractDetail.getNetworkId(), SettingValue.create((String)contractDetail.toJSONString()));
        if (contractDetail.isDefaultContract()) {
            SettingValue defaultContractsAddressesValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey);
            String defaultContractsAddresses = defaultContractsAddressesValue == null ? address : defaultContractsAddressesValue.getValue().toString() + "," + address;
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey, SettingValue.create((String)defaultContractsAddresses));
        }
    }

    public boolean removeDefaultContract(String address, Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't remove empty address for contract");
            return false;
        }
        if (networkId == null || networkId == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return false;
        }
        String defaultContractsParamKey = "WALLET_DEFAULT_CONTRACTS" + networkId;
        String defaultAddressToSave = address.toLowerCase();
        SettingValue defaultContractsAddressesValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey);
        if (defaultContractsAddressesValue != null) {
            String[] contractAddresses = defaultContractsAddressesValue.getValue().toString().split(",");
            Set contractAddressList = Arrays.stream(contractAddresses).filter(contractAddress -> !contractAddress.equalsIgnoreCase(defaultAddressToSave)).collect(Collectors.toSet());
            String contractAddressValue = StringUtils.join(contractAddressList, (String)",");
            this.settingService.remove(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address + networkId);
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey, SettingValue.create((String)contractAddressValue));
        }
        return true;
    }

    public ContractDetail getContractDetail(String address, Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            return null;
        }
        Set<String> defaultContracts = this.getDefaultContractsAddresses(networkId);
        if (defaultContracts != null && !defaultContracts.contains(address)) {
            return null;
        }
        SettingValue contractDetailValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address + networkId);
        if (contractDetailValue != null) {
            return ContractDetail.parseStringToObject((String)contractDetailValue.getValue());
        }
        return null;
    }

    public Set<String> getDefaultContractsAddresses(Long networkId) {
        if (networkId == null || networkId == 0L) {
            return Collections.emptySet();
        }
        String defaultContractsParamKey = "WALLET_DEFAULT_CONTRACTS" + networkId;
        SettingValue defaultContractsAddressesValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey);
        if (defaultContractsAddressesValue != null) {
            String defaultContractsAddressesString = defaultContractsAddressesValue.getValue().toString().toLowerCase();
            String[] contractAddresses = defaultContractsAddressesString.split(",");
            return Arrays.stream(contractAddresses).map(String::toLowerCase).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public String getContract(String name, String extension) throws IOException {
        try (InputStream abiInputStream = this.getClass().getClassLoader().getResourceAsStream("org/exoplatform/addon/ethereum/wallet/contract/" + name + "." + extension);){
            String string = IOUtils.toString((InputStream)abiInputStream);
            return string;
        }
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }
}

