/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import org.apache.commons.codec.binary.StringUtils;

public enum WalletType {
    USER,
    SPACE;

    private String id = this.name().toLowerCase();
    private String providerId = this.ordinal() == 0 ? "organization" : "space";

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public boolean isSpace() {
        return this == SPACE;
    }

    public boolean isUser() {
        return this == USER;
    }

    public static WalletType getType(String type) {
        return StringUtils.equals((CharSequence)"space", (CharSequence)type) || SPACE.name().equalsIgnoreCase(type) ? SPACE : USER;
    }

    public static boolean isSpace(String type) {
        return StringUtils.equals((CharSequence)"space", (CharSequence)type) || SPACE.name().equalsIgnoreCase(type);
    }

    public static boolean isUser(String type) {
        return StringUtils.equals((CharSequence)"organization", (CharSequence)type) || USER.name().equalsIgnoreCase(type);
    }
}

