/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WalletAddressModifiedListener
extends Listener<Wallet, Wallet> {
    private static final Log LOG = ExoLogger.getLogger(WalletAddressModifiedListener.class);
    private EthereumWalletService ethereumWalletService;

    public void onEvent(Event<Wallet, Wallet> event) throws Exception {
        Wallet wallet = (Wallet)event.getData();
        Wallet oldWallet = (Wallet)event.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)wallet.getAddress(), (CharSequence)oldWallet.getAddress())) {
            return;
        }
        GlobalSettings settings = this.getEthereumWalletService().getSettings();
        Map<String, Double> initialFunds = settings.getInitialFunds();
        if (initialFunds == null || initialFunds.isEmpty() || settings.getFundsHolder() == null || settings.getFundsHolder().isEmpty() || wallet.getId() == null || settings.getFundsHolder().equals(wallet.getId())) {
            return;
        }
        Set<String> addresses = initialFunds.keySet();
        for (String address : addresses) {
            Double amount = initialFunds.get(address);
            if (amount == null || amount == 0.0) {
                LOG.info("Fund request amount is 0, thus no notification will be sent.", new Object[]{address});
                continue;
            }
            address = address.toLowerCase();
            FundsRequest request = new FundsRequest();
            if (!"ether".equalsIgnoreCase(address)) {
                if (!settings.getDefaultContractsToDisplay().contains(address)) {
                    LOG.warn("Can't find contract with address {}. No fund request notification will be sent.", new Object[]{address});
                    continue;
                }
                request.setContract(address);
            }
            request.setAmount(amount);
            request.setAddress(wallet.getAddress());
            request.setReceipient(settings.getFundsHolder());
            request.setReceipientType(settings.getFundsHolderType());
            request.setMessage("Wallet address has been modified from " + oldWallet.getAddress() + " to " + wallet.getAddress() + " . Would you like to send to wallet the initial funds ?");
            try {
                this.getEthereumWalletService().requestFunds(request);
            }
            catch (Exception e) {
                LOG.error((Object)("Unknown error occurred while user '" + Utils.getCurrentUserId() + "' requesting funds for wallet of type '" + wallet.getType() + "' with id '" + wallet.getId() + "'"), (Throwable)e);
                throw e;
            }
        }
    }

    public EthereumWalletService getEthereumWalletService() {
        if (this.ethereumWalletService == null) {
            this.ethereumWalletService = (EthereumWalletService)CommonsUtils.getService(EthereumWalletService.class);
        }
        return this.ethereumWalletService;
    }
}

