/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.storage.cached;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.dao.WalletAccountDAO;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletCacheKey;
import org.exoplatform.addon.ethereum.wallet.storage.AccountStorage;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CachedAccountStorage
extends AccountStorage {
    private FutureExoCache<WalletCacheKey, Wallet, Object> walletFutureCache = null;

    public CachedAccountStorage(CacheService cacheService, WalletAccountDAO walletAccountDAO) {
        super(walletAccountDAO);
        ExoCache walletCache = cacheService.getCacheInstance("wallet.account");
        this.walletFutureCache = new FutureExoCache((Loader)new Loader<WalletCacheKey, Wallet, Object>(){

            public Wallet retrieve(Object context, WalletCacheKey cacheKey) throws Exception {
                if (StringUtils.isBlank((String)cacheKey.getAddress())) {
                    return CachedAccountStorage.super.getWalletByIdentityId(cacheKey.getIdentityId());
                }
                return CachedAccountStorage.super.getWalletByAddress(cacheKey.getAddress());
            }
        }, walletCache);
    }

    @Override
    public Wallet getWalletByAddress(String address) {
        Wallet wallet = (Wallet)this.walletFutureCache.get(null, (Object)new WalletCacheKey(address));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public Wallet getWalletByIdentityId(long identityId) {
        Wallet wallet = (Wallet)this.walletFutureCache.get(null, (Object)new WalletCacheKey(identityId));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public void saveWallet(Wallet wallet, boolean isNew) {
        String oldAddress = null;
        if (!isNew) {
            Wallet oldWallet = this.getWalletByIdentityId(wallet.getTechnicalId());
            oldAddress = oldWallet == null ? null : oldWallet.getAddress();
        }
        super.saveWallet(wallet, isNew);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        if (StringUtils.isNotBlank((String)oldAddress) && !StringUtils.equalsIgnoreCase((String)oldAddress, (String)wallet.getAddress())) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(oldAddress));
        }
    }

    @Override
    public Wallet removeWallet(long identityId) {
        Wallet wallet = super.removeWallet(identityId);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        return wallet;
    }
}

