/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.entity.TransactionEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class WalletTransactionDAO
extends GenericDAOJPAImpl<TransactionEntity, Long> {
    private static final String HASH_PARAM = "hash";
    private static final String ADDRESS_PARAM = "address";
    private static final String CONTRACT_ADDRESS_PARAM = "contractAddress";
    private static final String NETWORK_ID_PARAM = "networkId";

    public List<TransactionEntity> getContractTransactions(long networkId, String contractAddress, int limit) {
        contractAddress = StringUtils.lowerCase((String)contractAddress);
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getContractTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)contractAddress.toLowerCase());
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<TransactionEntity> getWalletTransactions(long networkId, String address, String contractAddress, int limit, boolean pending, boolean administration) {
        address = StringUtils.lowerCase((String)address);
        contractAddress = StringUtils.lowerCase((String)contractAddress);
        StringBuilder queryString = new StringBuilder("SELECT tx FROM WalletTransaction tx WHERE tx.networkId = ");
        queryString.append(networkId);
        if (!administration) {
            queryString.append(" AND tx.isAdminOperation = FALSE");
        }
        queryString.append(" AND (tx.fromAddress = '");
        queryString.append(address);
        queryString.append("' OR tx.toAddress = '");
        queryString.append(address);
        queryString.append("' OR tx.byAddress = '");
        queryString.append(address);
        queryString.append("')");
        if (pending) {
            queryString.append(" AND tx.isPending = TRUE");
        }
        if (StringUtils.isNotBlank((CharSequence)contractAddress)) {
            queryString.append(" AND tx.contractAddress = '");
            queryString.append(contractAddress);
            queryString.append("' ");
        }
        queryString.append(" ORDER BY tx.createdDate DESC");
        TypedQuery query = this.getEntityManager().createQuery(queryString.toString(), TransactionEntity.class);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<TransactionEntity> getPendingTransactions(long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        return query.getResultList();
    }

    public TransactionEntity getTransactionByHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getTransactionByHash", TransactionEntity.class);
        query.setParameter(HASH_PARAM, (Object)StringUtils.lowerCase((String)hash));
        List resultList = query.getResultList();
        return resultList == null || resultList.isEmpty() ? null : (TransactionEntity)resultList.get(0);
    }

    public TransactionEntity getAddressLastPendingTransactionSent(long networkId, String address) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getAddressLastPendingTransactionSent", TransactionEntity.class);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setMaxResults(1);
        List resultList = query.getResultList();
        return resultList == null || resultList.isEmpty() ? null : (TransactionEntity)resultList.get(0);
    }
}

