/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.notification.plugin;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;

public class FundsRequestNotificationPlugin
extends BaseNotificationPlugin {
    public FundsRequestNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return "FundsRequestNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        Wallet requestSenderDetail = (Wallet)ctx.value(Utils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER);
        Wallet requestSenderAccountDetail = (Wallet)ctx.value(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        Wallet requestReceiverAccountDetail = (Wallet)ctx.value(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        ContractDetail contractDetail = (ContractDetail)ctx.value(Utils.CONTRACT_DETAILS_PARAMETER);
        FundsRequest fundsRequest = (FundsRequest)ctx.value(Utils.FUNDS_REQUEST_PARAMETER);
        List toList = Utils.getNotificationReceiversUsers((Wallet)requestReceiverAccountDetail, (String)requestSenderDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        String requestAcceptURL = Utils.getWalletLink(null, null) + "?receiver=" + requestSenderAccountDetail.getId() + "&receiver_type=" + requestSenderAccountDetail.getType() + "&amount=" + fundsRequest.getAmount();
        String contractAddress = fundsRequest.getContract();
        String symbol = null;
        if (StringUtils.isNotBlank((CharSequence)contractAddress)) {
            if (contractDetail == null) {
                throw new IllegalStateException("Can't find contract with address " + contractAddress);
            }
            requestAcceptURL = requestAcceptURL + "&contract=" + contractDetail.getAddress();
            symbol = contractDetail.getSymbol();
        } else {
            symbol = "ether";
        }
        return NotificationInfo.instance().to(toList).with("amount", String.valueOf(fundsRequest.getAmount())).with("account_type", requestSenderAccountDetail.getType()).with("avatar", CommonsUtils.getCurrentDomain() + requestSenderAccountDetail.getAvatar()).with("senderUrl", Utils.getPermanentLink((Wallet)requestSenderAccountDetail)).with("receiverUrl", Utils.getPermanentLink((Wallet)requestReceiverAccountDetail)).with("fundsAcceptUrl", requestAcceptURL).with("userFullname", requestSenderDetail.getName()).with("userUrl", Utils.getPermanentLink((Wallet)requestSenderDetail)).with("sender", requestSenderAccountDetail.getName()).with("receiver", requestReceiverAccountDetail.getName()).with("symbol", symbol).with("message", fundsRequest.getMessage() == null ? "" : fundsRequest.getMessage()).key(this.getKey()).end();
    }
}

