/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.task.service;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.task.model.WalletAdminTask;
import org.exoplatform.addon.ethereum.wallet.task.service.WalletTaskService;
import org.exoplatform.addon.ethereum.wallet.task.storage.WalletTaskStorage;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.social.core.identity.model.Identity;

public class WalletTaskServiceImpl
implements WalletTaskService {
    private WalletTaskStorage walletTaskStorage;

    public WalletTaskServiceImpl(WalletTaskStorage walletTaskStorage) {
        this.walletTaskStorage = walletTaskStorage;
    }

    public Set<WalletAdminTask> listTasks(String userId) {
        long identityId = this.getUserIdentityId(userId);
        return this.walletTaskStorage.listTasks(identityId);
    }

    public Set<WalletAdminTask> getTasksByType(String taskType) {
        return this.walletTaskStorage.getTasksByType(taskType);
    }

    public void save(WalletAdminTask task, String assignee) {
        long assigneeIdentityId = 0L;
        if (StringUtils.isNotBlank((CharSequence)assignee)) {
            assigneeIdentityId = this.getUserIdentityId(assignee);
        }
        this.walletTaskStorage.save(task, assigneeIdentityId);
    }

    public void markCompleted(long taskId) {
        this.walletTaskStorage.markCompleted(taskId);
    }

    private long getUserIdentityId(String userId) {
        Identity identity = Utils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)userId);
        return Long.parseLong(identity.getId());
    }
}

