/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.task.storage;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.addon.ethereum.wallet.task.dao.WalletTaskDAO;
import org.exoplatform.addon.ethereum.wallet.task.entity.WalletTaskEntity;
import org.exoplatform.addon.ethereum.wallet.task.model.WalletAdminTask;

public class WalletTaskStorage {
    private WalletTaskDAO walletTaskDAO;

    public WalletTaskStorage(WalletTaskDAO walletTaskDAO) {
        this.walletTaskDAO = walletTaskDAO;
    }

    public Set<WalletAdminTask> listTasks(long identityId) {
        List<WalletTaskEntity> listTasks = this.walletTaskDAO.listTasks(identityId);
        return this.fromEntity(listTasks);
    }

    public void save(WalletAdminTask task, long assigneeIdentityId) {
        WalletTaskEntity taskEntity = new WalletTaskEntity();
        if (task.getId() <= 0L) {
            taskEntity.setId(null);
        } else {
            taskEntity.setId(task.getId());
        }
        taskEntity.setCompleted(task.isCompleted());
        taskEntity.setParameters(task.getParameters());
        taskEntity.setLink(task.getLink());
        taskEntity.setType(task.getType());
        taskEntity.setAssignee(assigneeIdentityId);
        if (taskEntity.getId() == null) {
            this.walletTaskDAO.create(taskEntity);
        } else {
            this.walletTaskDAO.update(taskEntity);
        }
    }

    public Set<WalletAdminTask> getTasksByType(String taskType) {
        List<WalletTaskEntity> listTasks = this.walletTaskDAO.getTasksByType(taskType);
        return this.fromEntity(listTasks);
    }

    public void markCompleted(long taskId) {
        WalletTaskEntity task = (WalletTaskEntity)this.walletTaskDAO.find(Long.valueOf(taskId));
        if (task == null) {
            throw new IllegalStateException("Task with id " + taskId + " wasn't found");
        }
        task.setCompleted(true);
        this.walletTaskDAO.update(task);
    }

    private Set<WalletAdminTask> fromEntity(List<WalletTaskEntity> listTasks) {
        return listTasks == null ? Collections.emptySet() : listTasks.stream().map(this::fromEntity).collect(Collectors.toSet());
    }

    private WalletAdminTask fromEntity(WalletTaskEntity entity) {
        WalletAdminTask walletAdminTask = new WalletAdminTask();
        walletAdminTask.setId(entity.getId().longValue());
        walletAdminTask.setMessage(entity.getMessage());
        walletAdminTask.setParameters(entity.getParameters());
        walletAdminTask.setCompleted(entity.getCompleted().booleanValue());
        walletAdminTask.setType(entity.getType());
        walletAdminTask.setMessage(entity.getMessage());
        walletAdminTask.setLink(entity.getLink());
        return walletAdminTask;
    }
}

