package org.exoplatform.addon.ethereum.wallet.ext.gamification.entity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.*;

import org.hibernate.annotations.DynamicUpdate;

import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationRewardType;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name = "WalletGamificationTeam")
@ExoEntity
@DynamicUpdate
@Table(name = "ADDONS_WALLET_GAM_TEAM")
public class GamificationTeamEntity implements Serializable {

  private static final long                 serialVersionUID = 4475704534821391132L;

  @Id
  @SequenceGenerator(name = "SEQ_WALLET_GAM_TEAM_ID", sequenceName = "SEQ_WALLET_GAM_TEAM_ID")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_WALLET_GAM_TEAM_ID")
  @Column(name = "TEAM_ID")
  private Long                              id;

  @Column(name = "TEAM_NAME", unique = true, nullable = false)
  private String                            name;

  @Column(name = "TEAM_DESCRIPTION")
  private String                            description;

  @Column(name = "TEAM_REWARD_TYPE")
  private GamificationRewardType        rewardType;

  @Column(name = "TEAM_BUDGET")
  private Double                            budget;

  @Column(name = "TEAM_MEMBER_REWARD")
  private Double                            rewardPerMember;

  @Column(name = "TEAM_SPACE_ID")
  private Long                              spaceId;

  @Column(name = "TEAM_MANAGER_ID")
  private Long                              manager;

  @OneToMany(mappedBy = "team", fetch = FetchType.EAGER, cascade = { CascadeType.ALL }, orphanRemoval = true)
  private Set<GamificationTeamMemberEntity> members          = new HashSet<>();

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Double getBudget() {
    return budget;
  }

  public void setBudget(Double budget) {
    this.budget = budget;
  }

  public Long getSpaceId() {
    return spaceId;
  }

  public void setSpaceId(Long spaceId) {
    this.spaceId = spaceId;
  }

  public Long getManager() {
    return manager;
  }

  public void setManager(Long manager) {
    this.manager = manager;
  }

  public Double getRewardPerMember() {
    return rewardPerMember;
  }

  public void setRewardPerMember(Double rewardPerMember) {
    this.rewardPerMember = rewardPerMember;
  }

  public GamificationRewardType getRewardType() {
    return rewardType;
  }

  public void setRewardType(GamificationRewardType rewardType) {
    this.rewardType = rewardType;
  }

  public Set<GamificationTeamMemberEntity> getMembers() {
    return members;
  }

  public void setMembers(Set<GamificationTeamMemberEntity> members) {
    this.members = members;
  }
}
