/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.model.reward;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.WalletReward;

public class RewardReport {
    private RewardPeriod period = null;
    private Set<WalletReward> rewards = new HashSet<WalletReward>();

    public long countPending() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null && StringUtils.equals((String)rewardItem.getTransaction().getStatus(), (String)"pending")).count();
    }

    public long countSuccess() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null && StringUtils.equals((String)rewardItem.getTransaction().getStatus(), (String)"success")).count();
    }

    public long countFailed() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null && StringUtils.equals((String)rewardItem.getTransaction().getStatus(), (String)"error")).count();
    }

    public long countTransactions() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null).count();
    }

    public Set<WalletReward> getValidRewards() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTokensToSend() > 0.0).collect(Collectors.toSet());
    }

    public double totalAmount() {
        return this.rewards.stream().mapToDouble(rewardItem -> rewardItem.getTokensSent()).sum();
    }

    public long countValidRewards() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTokensToSend() > 0.0).count();
    }

    public boolean hasSuccessTransactions() {
        return this.countSuccess() > 0L;
    }

    public boolean hasPendingTransactions() {
        return this.countPending() > 0L;
    }

    public boolean hasErrorTransactions() {
        return this.countFailed() > 0L;
    }

    public boolean isCompletelyProceeded() {
        return this.countSuccess() == this.countValidRewards();
    }

    public RewardPeriod getPeriod() {
        return this.period;
    }

    public Set<WalletReward> getRewards() {
        return this.rewards;
    }

    public void setPeriod(RewardPeriod period) {
        this.period = period;
    }

    public void setRewards(Set<WalletReward> rewards) {
        this.rewards = rewards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardReport)) {
            return false;
        }
        RewardReport other = (RewardReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RewardPeriod this$period = this.getPeriod();
        RewardPeriod other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Set<WalletReward> this$rewards = this.getRewards();
        Set<WalletReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RewardReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RewardPeriod $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Set<WalletReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        return result;
    }

    public String toString() {
        return "RewardReport(period=" + this.getPeriod() + ", rewards=" + this.getRewards() + ")";
    }
}

