// Generated by delombok at Mon May 03 14:50:04 UTC 2021
/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 Meeds Association
 * contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.exoplatform.wallet.model.reward;

import static org.exoplatform.wallet.utils.RewardUtils.formatTime;
import java.io.Serializable;
import java.time.LocalDateTime;

public class RewardPeriod implements Serializable {
  private static final long serialVersionUID = -4860665131754056537L;
  private RewardPeriodType rewardPeriodType;
  private long startDateInSeconds;
  private long endDateInSeconds;

  public RewardPeriod(RewardPeriodType rewardPeriodType) {
    this.rewardPeriodType = rewardPeriodType;
  }

  public static RewardPeriod getCurrentPeriod(RewardSettings rewardSettings) {
    return getPeriodOfTime(rewardSettings, LocalDateTime.now());
  }

  public static RewardPeriod getPeriodOfTime(RewardSettings rewardSettings, LocalDateTime localDateTime) {
    RewardPeriodType rewardPeriodType = null;
    if (rewardSettings == null || rewardSettings.getPeriodType() == null) {
      rewardPeriodType = RewardPeriodType.DEFAULT;
    } else {
      rewardPeriodType = rewardSettings.getPeriodType();
    }
    return rewardPeriodType.getPeriodOfTime(localDateTime);
  }

  public String getStartDateFormatted(String lang) {
    return formatTime(startDateInSeconds, lang);
  }

  public String getEndDateFormatted(String lang) {
    return formatTime(endDateInSeconds, lang);
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriodType getRewardPeriodType() {
    return this.rewardPeriodType;
  }

  @java.lang.SuppressWarnings("all")
  public long getStartDateInSeconds() {
    return this.startDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public long getEndDateInSeconds() {
    return this.endDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public void setRewardPeriodType(final RewardPeriodType rewardPeriodType) {
    this.rewardPeriodType = rewardPeriodType;
  }

  @java.lang.SuppressWarnings("all")
  public void setStartDateInSeconds(final long startDateInSeconds) {
    this.startDateInSeconds = startDateInSeconds;
  }

  @java.lang.SuppressWarnings("all")
  public void setEndDateInSeconds(final long endDateInSeconds) {
    this.endDateInSeconds = endDateInSeconds;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof RewardPeriod)) return false;
    final RewardPeriod other = (RewardPeriod) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$rewardPeriodType = this.getRewardPeriodType();
    final java.lang.Object other$rewardPeriodType = other.getRewardPeriodType();
    if (this$rewardPeriodType == null ? other$rewardPeriodType != null : !this$rewardPeriodType.equals(other$rewardPeriodType)) return false;
    if (this.getStartDateInSeconds() != other.getStartDateInSeconds()) return false;
    if (this.getEndDateInSeconds() != other.getEndDateInSeconds()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof RewardPeriod;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $rewardPeriodType = this.getRewardPeriodType();
    result = result * PRIME + ($rewardPeriodType == null ? 43 : $rewardPeriodType.hashCode());
    final long $startDateInSeconds = this.getStartDateInSeconds();
    result = result * PRIME + (int) ($startDateInSeconds >>> 32 ^ $startDateInSeconds);
    final long $endDateInSeconds = this.getEndDateInSeconds();
    result = result * PRIME + (int) ($endDateInSeconds >>> 32 ^ $endDateInSeconds);
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "RewardPeriod(rewardPeriodType=" + this.getRewardPeriodType() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", endDateInSeconds=" + this.getEndDateInSeconds() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriod() {
  }
}
