/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.task.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.wallet.model.task.WalletAdminTask;
import org.exoplatform.addon.wallet.task.service.WalletTaskService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/wallet/api/task")
@RolesAllowed(value={"users"})
@Api(value="/wallet/api/task", description="Manage wallet administration tasks")
public class WalletTaskREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletTaskREST.class);
    private WalletTaskService walletTaskService;

    public WalletTaskREST(WalletTaskService walletTaskService) {
        this.walletTaskService = walletTaskService;
    }

    @GET
    @Path(value="list")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get list of wallet administration tasks assigned to a user", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of wallet admin task objects")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response listTasks() {
        ConversationState currentState = ConversationState.getCurrent();
        if (currentState == null || currentState.getIdentity() == null || currentState.getIdentity().getUserId() == null || currentState.getIdentity().getRoles() == null || !currentState.getIdentity().getRoles().contains("rewarding")) {
            return Response.ok(Collections.emptyList()).build();
        }
        try {
            Set<WalletAdminTask> tasks = this.walletTaskService.listTasks(currentState.getIdentity().getUserId());
            return Response.ok(tasks).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting listing tasks", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="markCompleted")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Marks a task identified by its technical id as completed", httpMethod="GET", response=Response.class, produces="application/json", notes="returns empty object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response markCompleted(@ApiParam(value="Task technical id", required=true) @QueryParam(value="taskId") long taskId) {
        try {
            this.walletTaskService.markCompleted(taskId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn("Error marking task with id {} as completed", new Object[]{taskId, e});
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }
}

