/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.scheduled;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Set;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.RewardPeriodType;
import org.exoplatform.addon.wallet.model.reward.RewardSettings;
import org.exoplatform.addon.wallet.model.task.WalletAdminTask;
import org.exoplatform.addon.wallet.reward.service.RewardSettingsService;
import org.exoplatform.addon.wallet.task.service.WalletTaskService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RewardReminderJob
implements Job {
    private static final String REWARD_WALLET_TASK_TYPE = "reward";
    private static final Log LOG = ExoLogger.getLogger(RewardReminderJob.class);
    private WalletTaskService walletTaskService;
    private RewardSettingsService rewardSettingsService;
    private ExoContainer container;

    public RewardReminderJob() {
        this(PortalContainer.getInstance());
    }

    public RewardReminderJob(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            RewardPeriodType periodType;
            if (this.getWalletTaskService() == null) {
                return;
            }
            RewardSettings rewardSettings = this.getRewardSettingsService().getSettings();
            RewardPeriodType rewardPeriodType = periodType = rewardSettings == null ? null : rewardSettings.getPeriodType();
            if (rewardSettings == null || periodType == null) {
                return;
            }
            ZonedDateTime now = ZonedDateTime.now();
            RewardPeriod periodOfTime = periodType.getPeriodOfTime(now.toLocalDateTime());
            long endDateInSeconds = periodOfTime.getEndDateInSeconds();
            long daysUntilRewardPayment = Duration.ofSeconds(endDateInSeconds - now.toEpochSecond()).toDays();
            if (daysUntilRewardPayment <= (long)this.getRewardSettingsService().getReminderDateInDays()) {
                ArrayList<String> parameters;
                Set adminTasks = this.getWalletTaskService().getTasksByType(REWARD_WALLET_TASK_TYPE);
                WalletAdminTask adminTask = null;
                if (adminTasks != null && !adminTasks.isEmpty()) {
                    adminTask = (WalletAdminTask)adminTasks.iterator().next();
                    if (adminTasks.size() > 1) {
                        LOG.warn("More than one task for type {} is retrieved from database", new Object[]{REWARD_WALLET_TASK_TYPE});
                    }
                }
                if (adminTask == null) {
                    adminTask = new WalletAdminTask();
                    adminTask.setType(REWARD_WALLET_TASK_TYPE);
                }
                if ((parameters = adminTask.getParameters()) == null) {
                    parameters = new ArrayList<String>();
                    adminTask.setParameters(parameters);
                } else {
                    parameters.clear();
                }
                adminTask.setCompleted(false);
                parameters.add(String.valueOf(periodOfTime.getStartDateInSeconds()));
                parameters.add(String.valueOf(periodOfTime.getEndDateInSeconds()));
                this.getWalletTaskService().save(adminTask, null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private WalletTaskService getWalletTaskService() {
        if (this.walletTaskService == null) {
            this.walletTaskService = (WalletTaskService)CommonsUtils.getService(WalletTaskService.class);
        }
        return this.walletTaskService;
    }

    private RewardSettingsService getRewardSettingsService() {
        if (this.rewardSettingsService == null) {
            this.rewardSettingsService = (RewardSettingsService)CommonsUtils.getService(RewardSettingsService.class);
        }
        return this.rewardSettingsService;
    }
}

