/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/admin/transaction")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/admin/transaction", description="Manages admin wallet transactions to send on blockchain")
public class WalletAdminTransactionREST
implements ResourceContainer {
    private static final String BAD_REQUEST_SENT_TO_SERVER_BY = "Bad request sent to server by '";
    private static final Log LOG = ExoLogger.getLogger(WalletAdminTransactionREST.class);
    private WalletTokenAdminService walletTokenAdminService;

    @POST
    @Path(value="intiialize")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Send blockchain transaction using Admin wallet to initialize wallet identified by its address", httpMethod="POST", response=Response.class, notes="returns transaction hash")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response intializeWallet(@ApiParam(value="receiver wallet address", required=true) @FormParam(value="receiver") String receiver, @ApiParam(value="ether amount to send to wallet", required=false) @FormParam(value="etherAmount") double etherAmount, @ApiParam(value="token amount to send to wallet", required=false) @FormParam(value="tokenAmount") double tokenAmount, @ApiParam(value="transaction label", required=false) @FormParam(value="transactionLabel") String transactionLabel, @ApiParam(value="transaction message to send to receiver with transaction", required=false) @FormParam(value="transactionMessage") String transactionMessage) {
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isBlank((String)receiver)) {
            LOG.warn((Object)(BAD_REQUEST_SENT_TO_SERVER_BY + currentUserId + "' with empty address"));
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setTo(receiver);
            transactionDetail.setContractAmount(tokenAmount);
            transactionDetail.setValue(etherAmount);
            transactionDetail.setLabel(transactionLabel);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getWalletTokenAdminService().initialize(transactionDetail, currentUserId);
            return Response.ok((Object)(transactionDetail == null ? "" : transactionDetail.getHash())).build();
        }
        catch (Exception e) {
            LOG.error("Error initializing wallet {}", new Object[]{receiver, e});
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="sendEther")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Send ether using blockchain transaction from Admin wallet", httpMethod="POST", response=Response.class, notes="returns transaction hash")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response sendEther(@ApiParam(value="receiver wallet address", required=true) @FormParam(value="receiver") String receiver, @ApiParam(value="ether amount to send", required=true) @FormParam(value="etherAmount") double etherAmount, @ApiParam(value="transaction label", required=false) @FormParam(value="transactionLabel") String transactionLabel, @ApiParam(value="transaction message to send to receiver with transaction", required=false) @FormParam(value="transactionMessage") String transactionMessage) {
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isBlank((String)receiver)) {
            LOG.warn((Object)(BAD_REQUEST_SENT_TO_SERVER_BY + currentUserId + "' with empty address"));
            return Response.status((int)400).build();
        }
        if (etherAmount <= 0.0) {
            LOG.warn("Wrong ether amount '{}' sent to server", new Object[]{etherAmount});
            return Response.status((int)400).build();
        }
        try {
            GlobalSettings settings = WalletUtils.getSettings();
            if (settings == null || settings.getInitialFunds() == null || settings.getInitialFunds().getEtherAmount() <= 0.0) {
                throw new IllegalStateException("Can't send ether to wallet " + receiver + " because no default ether amount is configured in settings: " + settings);
            }
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setTo(receiver);
            transactionDetail.setValue(etherAmount);
            transactionDetail.setLabel(transactionLabel);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getWalletTokenAdminService().sendEther(transactionDetail, currentUserId);
            return Response.ok((Object)(transactionDetail == null ? "" : transactionDetail.getHash())).build();
        }
        catch (Exception e) {
            LOG.error("Error sending ether to wallet {}", new Object[]{receiver, e});
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="sendToken")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Send tokens using blockchain transaction from Admin wallet", httpMethod="POST", response=Response.class, notes="returns transaction hash")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response sendToken(@ApiParam(value="receiver wallet address", required=true) @FormParam(value="receiver") String receiver, @ApiParam(value="transaction label", required=false) @FormParam(value="transactionLabel") String transactionLabel, @ApiParam(value="transaction message to send to receiver with transaction", required=false) @FormParam(value="transactionMessage") String transactionMessage) {
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isBlank((String)receiver)) {
            LOG.warn((Object)(BAD_REQUEST_SENT_TO_SERVER_BY + currentUserId + "' with empty address"));
            return Response.status((int)400).build();
        }
        try {
            GlobalSettings settings = WalletUtils.getSettings();
            if (settings == null || settings.getInitialFunds() == null || settings.getInitialFunds().getTokenAmount() <= 0.0) {
                throw new IllegalStateException("Can't send tokens to wallet " + receiver + " because no default token amount is configured in settings: " + settings);
            }
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setTo(receiver);
            transactionDetail.setContractAmount(settings.getInitialFunds().getTokenAmount());
            transactionDetail.setLabel(transactionLabel);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getWalletTokenAdminService().sendToken(transactionDetail, currentUserId);
            return Response.ok((Object)(transactionDetail == null ? "" : transactionDetail.getHash())).build();
        }
        catch (Exception e) {
            LOG.error("Error sending token to wallet {}", new Object[]{receiver, e});
            return Response.serverError().build();
        }
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }
}

