/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.job;

import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ContractTransactionVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(ContractTransactionVerifierJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private BlockchainTransactionService blockchainTransactionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.getBlockchainTransactionService().scanNewerBlocks();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private BlockchainTransactionService getBlockchainTransactionService() {
        if (this.blockchainTransactionService == null) {
            this.blockchainTransactionService = (BlockchainTransactionService)CommonsUtils.getService(BlockchainTransactionService.class);
        }
        return this.blockchainTransactionService;
    }
}

