/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.wallet.model.reward.RewardTeam;
import org.exoplatform.addon.wallet.reward.service.RewardTeamService;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/reward/team")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/reward/team", description="Manage reward teams (pools)")
public class RewardTeamREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardTeamREST.class);
    private RewardTeamService rewardTeamService;

    public RewardTeamREST(RewardTeamService rewardTeamService) {
        this.rewardTeamService = rewardTeamService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Get reward teams with their members", httpMethod="GET", response=Response.class, produces="application/json", notes="returns the list of reward team objects")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response listTeams() {
        try {
            return Response.ok(this.rewardTeamService.getTeams()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="remove")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Remove a reward team", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response removeTeam(@ApiParam(value="Reward team technical id", required=true) @QueryParam(value="id") Long id) {
        if (id == null || id == 0L) {
            return Response.status((int)400).build();
        }
        try {
            RewardTeam team = this.rewardTeamService.removeTeam(id);
            LOG.info("{} removed reward pool {}", new Object[]{RewardUtils.getCurrentUserId(), team.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error removing reward pool with id: " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Save a reward team", httpMethod="POST", response=Response.class, consumes="application/json", produces="application/json", notes="returns saved reward team object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveTeam(@ApiParam(value="Reward team object", required=true) RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            LOG.warn((Object)"Bad request sent to server with empty team");
            return Response.status((int)400).build();
        }
        try {
            rewardTeam = this.rewardTeamService.saveTeam(rewardTeam);
            LOG.info("{} saved reward pool {}", new Object[]{RewardUtils.getCurrentUserId(), rewardTeam.getName()});
            return Response.ok((Object)rewardTeam).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving reward pool", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

