/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.RewardPeriodType;
import org.exoplatform.addon.wallet.model.reward.RewardSettings;
import org.exoplatform.addon.wallet.reward.service.RewardSettingsService;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/reward/settings")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/reward/settings", description="Manage reward module settings")
public class RewardSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardSettingsREST.class);
    private RewardSettingsService rewardSettingsService;

    public RewardSettingsREST(RewardSettingsService rewardSettingsService) {
        this.rewardSettingsService = rewardSettingsService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Get reward settings", httpMethod="GET", response=Response.class, produces="application/json", notes="returns reward settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings() {
        try {
            RewardSettings settings = this.rewardSettingsService.getSettings();
            return Response.ok((Object)(settings == null ? new RewardSettings() : settings)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Get reward settings", httpMethod="POST", response=Response.class, produces="application/json", notes="returns reward settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveSettings(@ApiParam(value="Reward settings object", required=true) RewardSettings rewardSettings) {
        if (rewardSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            this.rewardSettingsService.saveSettings(rewardSettings);
            LOG.info("{} saved reward settings '{}'", new Object[]{RewardUtils.getCurrentUserId(), rewardSettings.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="getDates")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get dates corresponding to chosen period type and start date", httpMethod="GET", response=Response.class, produces="application/json", notes="returns reward period dates object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getRewardDates(@ApiParam(value="Reward period type", required=true) @QueryParam(value="periodType") String periodType, @ApiParam(value="A chosen date to calculate its period", required=true) @QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn((Object)"Bad request sent to server with empty 'periodType' parameter");
            return Response.status((int)400).build();
        }
        RewardPeriodType rewardPeriodType = RewardPeriodType.valueOf(periodType);
        RewardPeriod rewardPeriod = rewardPeriodType.getPeriodOfTime(RewardUtils.timeFromSeconds(dateInSeconds));
        return Response.ok((Object)rewardPeriod).build();
    }
}

