/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.wallet.model.reward.RewardReport;
import org.exoplatform.addon.wallet.model.reward.WalletReward;
import org.exoplatform.addon.wallet.reward.service.RewardReportService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/wallet/api/reward/")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/reward", description="Manage wallet rewards")
public class RewardReportREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardReportREST.class);
    private RewardReportService rewardReportService;

    public RewardReportREST(RewardReportService rewardReportService) {
        this.rewardReportService = rewardReportService;
    }

    @GET
    @Path(value="compute")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Compute rewards of wallets per a chosen period of time", httpMethod="GET", response=Response.class, produces="application/json", notes="returns a set of wallet reward object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response computeRewards(@ApiParam(value="Start date of period in milliseconds", required=true) @QueryParam(value="periodDateInSeconds") long periodDateInSeconds) {
        if (periodDateInSeconds == 0L) {
            periodDateInSeconds = System.currentTimeMillis() / 1000L;
        }
        try {
            RewardReport rewardReport = this.rewardReportService.computeRewards(periodDateInSeconds);
            return Response.ok((Object)rewardReport).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="send")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Send rewards of wallets per a chosen period of time", httpMethod="GET", response=Response.class, notes="return empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response sendRewards(@ApiParam(value="Start date of period in milliseconds", required=true) @QueryParam(value="periodDateInSeconds") long periodDateInSeconds) {
        try {
            this.rewardReportService.sendRewards(periodDateInSeconds, WalletUtils.getCurrentUserId());
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="list")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Return list of rewards for current user with a limit of items to return", httpMethod="GET", produces="application/json", response=Response.class, notes="return list of rewards per user")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response listRewards(@ApiParam(value="limit of items to load", required=false) @QueryParam(value="limit") int limit) {
        try {
            List<WalletReward> rewards = this.rewardReportService.listRewards(WalletUtils.getCurrentUserId(), limit);
            return Response.ok(rewards).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting list of reward for current user", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }
}

