/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.settings.InitialFundsSettings;
import org.exoplatform.wallet.model.settings.UserSettings;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.utils.WalletUtils;

@Path(value="/wallet/api/settings")
@Api(value="/wallet/api/settings", description="Manages wallet module settings")
public class WalletSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletSettingsREST.class);
    private WalletService walletService;

    public WalletSettingsREST(WalletService walletService) {
        this.walletService = walletService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves user settings by including space settings when added in parameters", httpMethod="GET", produces="application/json", response=Response.class, notes="returns user settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings(@ApiParam(value="Space pretty name", required=false) @QueryParam(value="spaceId") String spaceId) {
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            UserSettings userSettings = this.walletService.getUserSettings(spaceId, currentUser);
            return Response.ok((Object)userSettings).build();
        }
        catch (Exception e) {
            LOG.error("Error getting settings for user {} and spaceId {}", new Object[]{currentUser, spaceId, e});
            return Response.status((int)401).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveInitialFunds")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Saves initial funds settings", httpMethod="POST", response=Response.class, consumes="application/json", notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveInitialFundsSettings(@ApiParam(value="Intial funds settings", required=true) InitialFundsSettings initialFundsSettings) {
        if (initialFundsSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            this.walletService.saveInitialFundsSettings(initialFundsSettings);
            LOG.info("{} saved initialFunds settings details '{}'", new Object[]{WalletUtils.getCurrentUserId(), initialFundsSettings.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving global settings", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

