/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.storage.cached;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.wallet.dao.WalletAccountBackupDAO;
import org.exoplatform.wallet.dao.WalletAccountDAO;
import org.exoplatform.wallet.dao.WalletBlockchainStateDAO;
import org.exoplatform.wallet.dao.WalletPrivateKeyDAO;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletCacheKey;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.storage.WalletStorage;
import org.exoplatform.web.security.codec.CodecInitializer;

public class CachedAccountStorage
extends WalletStorage {
    private FutureExoCache<WalletCacheKey, Wallet, String> walletFutureCache = null;

    public CachedAccountStorage(CacheService cacheService, WalletAccountDAO walletAccountDAO, WalletAccountBackupDAO walletAccountBackupDAO, WalletPrivateKeyDAO privateKeyDAO, WalletBlockchainStateDAO blockchainStateDAO, CodecInitializer codecInitializer) {
        super(walletAccountDAO, walletAccountBackupDAO, privateKeyDAO, blockchainStateDAO, codecInitializer);
        ExoCache walletCache = cacheService.getCacheInstance("wallet.account");
        this.walletFutureCache = new FutureExoCache((Loader)new Loader<WalletCacheKey, Wallet, String>(){

            public Wallet retrieve(String contractAddress, WalletCacheKey cacheKey) throws Exception {
                if (StringUtils.isBlank((String)cacheKey.getAddress())) {
                    return CachedAccountStorage.super.getWalletByIdentityId(cacheKey.getIdentityId(), contractAddress);
                }
                return CachedAccountStorage.super.getWalletByAddress(cacheKey.getAddress(), contractAddress);
            }
        }, walletCache);
    }

    @Override
    public Wallet getWalletByAddress(String address, String contractAddress) {
        Wallet wallet = (Wallet)this.walletFutureCache.get((Object)contractAddress, (Object)new WalletCacheKey(address));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public Wallet getWalletByIdentityId(long identityId, String contractAddress) {
        Wallet wallet = (Wallet)this.walletFutureCache.get((Object)contractAddress, (Object)new WalletCacheKey(identityId));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public Wallet saveWalletBackupState(long identityId, boolean backupState) {
        Wallet wallet = super.saveWalletBackupState(identityId, backupState);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        return wallet;
    }

    @Override
    public Wallet saveWallet(Wallet wallet, boolean isNew) {
        String oldAddress = null;
        if (!isNew) {
            Wallet oldWallet = this.getWalletByIdentityId(wallet.getTechnicalId(), null);
            oldAddress = oldWallet == null ? null : oldWallet.getAddress();
        }
        Wallet newWallet = super.saveWallet(wallet, isNew);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        if (StringUtils.isNotBlank((String)oldAddress) && !StringUtils.equalsIgnoreCase((String)oldAddress, (String)wallet.getAddress())) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(oldAddress));
        }
        return newWallet;
    }

    @Override
    public void switchToInternalWallet(long walletId) {
        super.switchToInternalWallet(walletId);
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    @Override
    public void switchToWalletProvider(long walletId, WalletProvider provider, String newAddress) {
        super.switchToWalletProvider(walletId, provider, newAddress);
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    @Override
    public void saveWalletBlockchainState(Wallet wallet, String contractAddress) {
        super.saveWalletBlockchainState(wallet, contractAddress);
        long walletId = wallet.getTechnicalId();
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
    }

    @Override
    public Wallet removeWallet(long identityId) {
        Wallet wallet = super.removeWallet(identityId);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        return wallet;
    }

    @Override
    public void removeWalletPrivateKey(long walletId) {
        super.removeWalletPrivateKey(walletId);
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    @Override
    public void saveWalletPrivateKey(long walletId, String content) {
        super.saveWalletPrivateKey(walletId, content);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    public void clearCache() {
        this.walletFutureCache.clear();
    }
}

