/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.utils.RewardUtils;

public enum RewardPeriodType {
    WEEK,
    MONTH,
    QUARTER,
    SEMESTER,
    YEAR;

    public static final RewardPeriodType DEFAULT;

    public RewardPeriod getPeriodOfTime(LocalDate date, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = date.atStartOfDay(zoneId);
        return this.getPeriodOfTime(zonedDateTime);
    }

    public RewardPeriod getPeriodOfTime(ZonedDateTime zonedDateTime) {
        ZoneId zoneId = zonedDateTime.getZone();
        RewardPeriod rewardPeriod = new RewardPeriod(this);
        rewardPeriod.setTimeZone(zoneId.getId());
        YearMonth yearMonth = YearMonth.from(zonedDateTime);
        switch (this) {
            case WEEK: {
                ZonedDateTime firstDayOfThisWeek = zonedDateTime.with(DayOfWeek.MONDAY);
                ZonedDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(firstDayOfThisWeek.toLocalDate(), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(firstDayOfNextWeek.toLocalDate(), zoneId));
                break;
            }
            case MONTH: {
                YearMonth currentMonth = yearMonth;
                YearMonth nextMonth = currentMonth.plusMonths(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(currentMonth.atDay(1), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(nextMonth.atDay(1), zoneId));
                break;
            }
            case QUARTER: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(startQuarterMonth.atDay(1), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(endQuarterMonth.atDay(1), zoneId));
                break;
            }
            case SEMESTER: {
                int monthSemesterIndex = (yearMonth.getMonthValue() - 1) / 6 * 6 + 1;
                YearMonth startSemesterMonth = YearMonth.of(yearMonth.getYear(), monthSemesterIndex);
                YearMonth endSemesterMonth = startSemesterMonth.plusMonths(6L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(startSemesterMonth.atDay(1), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(endSemesterMonth.atDay(1), zoneId));
                break;
            }
            case YEAR: {
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(Year.from(zonedDateTime).atDay(1), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(Year.from(zonedDateTime).plusYears(1L).atDay(1), zoneId));
            }
        }
        return rewardPeriod;
    }

    static {
        DEFAULT = MONTH;
    }
}

