/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.listener;

import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.reward.service.WalletRewardReportService;

public class TransactionReplacedListener
extends Listener<Object, Map<String, String>> {
    private static final Log LOG = ExoLogger.getLogger(TransactionReplacedListener.class);
    private WalletRewardReportService walletRewardReportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, Map<String, String>> event) throws Exception {
        String oldHash = null;
        String newHash = null;
        PortalContainer container = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            Map transaction = (Map)event.getData();
            oldHash = (String)transaction.get("oldHash");
            newHash = (String)transaction.get("hash");
            this.getWalletRewardReportService().replaceRewardTransactions(oldHash, newHash);
        }
        catch (Exception e) {
            LOG.error("Error while replacing Reward transaction from old hash {} to new hash {}", new Object[]{oldHash, newHash, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private WalletRewardReportService getWalletRewardReportService() {
        if (this.walletRewardReportService == null) {
            this.walletRewardReportService = (WalletRewardReportService)ExoContainerContext.getService(WalletRewardReportService.class);
        }
        return this.walletRewardReportService;
    }
}

