/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.model;

public enum StateMutability {
    PURE("pure"),
    VIEW("view"),
    NON_PAYABLE("nonpayable"),
    PAYABLE("payable");

    private final String name;

    private StateMutability(String state) {
        this.name = state;
    }

    public static StateMutability findByName(String name) {
        for (StateMutability state : StateMutability.values()) {
            if (!state.name().equals(name)) continue;
            return state;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPayable() {
        return this == PAYABLE;
    }

    public boolean isPure() {
        return this == PURE;
    }

    public boolean isView() {
        return this == VIEW;
    }

    public static boolean isPayable(String state) {
        return StateMutability.PAYABLE.name.equals(state);
    }

    public static boolean isPure(String state) {
        return StateMutability.PURE.name.equals(state);
    }

    public static boolean isView(String state) {
        return StateMutability.VIEW.name.equals(state);
    }
}

