/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.plugin;

import java.util.List;
import org.exoplatform.commons.api.settings.FeaturePlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.service.WalletService;

public class WalletFeaturePlugin
extends FeaturePlugin {
    private static final String WALLET_FEATURE_NAME = "wallet";
    private ConversationRegistry conversationRegistry;
    private WalletService walletService;

    public String getName() {
        return WALLET_FEATURE_NAME;
    }

    public boolean isFeatureActiveForUser(String featureName, String username) {
        List stateKeys = this.getConversationRegistry().getStateKeys(username);
        for (StateKey stateKey : stateKeys) {
            ConversationState state = this.getConversationRegistry().getState(stateKey);
            Boolean walletEnabled = (Boolean)state.getAttribute("wallet.enabled");
            if (walletEnabled == null) continue;
            return walletEnabled;
        }
        GlobalSettings settings = this.getWalletService().getSettings();
        if (settings == null) {
            return false;
        }
        boolean walletEnabled = true;
        for (StateKey stateKey : stateKeys) {
            ConversationState state = this.getConversationRegistry().getState(stateKey);
            state.setAttribute("wallet.enabled", (Object)walletEnabled);
        }
        return walletEnabled;
    }

    private ConversationRegistry getConversationRegistry() {
        if (this.conversationRegistry == null) {
            this.conversationRegistry = (ConversationRegistry)CommonsUtils.getService(ConversationRegistry.class);
        }
        return this.conversationRegistry;
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }
}

