/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardStatus;
import org.hibernate.annotations.DynamicUpdate;

@Entity(name="RewardPeriod")
@DynamicUpdate
@Table(name="ADDONS_WALLET_REWARD_PERIOD")
@NamedQueries(value={@NamedQuery(name="RewardPeriod.findRewardPeriods", query="SELECT rp FROM RewardPeriod rp ORDER BY rp.startTime DESC"), @NamedQuery(name="RewardPeriod.findRewardPeriodsBetween", query="SELECT rp FROM RewardPeriod rp WHERE (rp.startTime >= :from AND rp.startTime <= :to) OR (rp.endTime >= :from AND rp.endTime <= :to) ORDER BY rp.startTime DESC"), @NamedQuery(name="RewardPeriod.findRewardPeriodByTypeAndTime", query="SELECT rp FROM RewardPeriod rp WHERE rp.periodType = :periodType AND rp.startTime <= :periodTime AND rp.endTime > :periodTime"), @NamedQuery(name="RewardPlugin.findRewardPeriodsByStatus", query="SELECT rp FROM RewardPeriod rp WHERE rp.status = :status")})
public class WalletRewardPeriodEntity
implements Serializable {
    private static final long serialVersionUID = -6286934482105645678L;
    @Id
    @SequenceGenerator(name="SEQ_WALLET_REWARD_PERIOD_ID", sequenceName="SEQ_WALLET_REWARD_PERIOD_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WALLET_REWARD_PERIOD_ID")
    @Column(name="REWARD_PERIOD_ID")
    private Long id;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="PERIOD_TYPE", nullable=false)
    private RewardPeriodType periodType;
    @Column(name="START_TIME", nullable=false)
    private Long startTime;
    @Column(name="END_TIME", nullable=false)
    private Long endTime;
    @Column(name="TIME_ZONE")
    private String timeZone;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    private RewardStatus status;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RewardPeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(RewardPeriodType periodType) {
        this.periodType = periodType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public RewardStatus getStatus() {
        return this.status;
    }

    public void setStatus(RewardStatus status) {
        this.status = status;
    }

    public String toString() {
        return "WalletRewardPeriodEntity [id=" + this.id + ", periodType=" + String.valueOf(this.periodType) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", status=" + String.valueOf(this.status) + "]";
    }
}

