/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.reward.RewardBudgetType;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.addon.wallet.model.reward.RewardSettings;
import org.exoplatform.addon.wallet.reward.api.RewardPlugin;
import org.exoplatform.addon.wallet.reward.service.RewardSettingsService;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.xml.InitParams;
import org.json.JSONArray;

public class WalletRewardSettingsService
implements RewardSettingsService {
    private static final String REMINDER_DAYS_PARAMETER = "reminder.days";
    private SettingService settingService;
    private RewardSettings rewardSettings;
    private Map<String, RewardPlugin> rewardPlugins = new HashMap<String, RewardPlugin>();
    private int reminderDateInDays = 3;

    public WalletRewardSettingsService(SettingService settingService, InitParams params) {
        this.settingService = settingService;
        if (params != null && params.containsKey((Object)REMINDER_DAYS_PARAMETER)) {
            this.reminderDateInDays = Integer.parseInt(params.getValueParam(REMINDER_DAYS_PARAMETER).getValue());
        }
    }

    public RewardSettings getSettings() {
        Set<String> configuredPluginIds;
        HashSet<RewardPluginSettings> pluginSettings;
        if (this.rewardSettings != null) {
            return this.rewardSettings.clone();
        }
        SettingValue settingsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS");
        String settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        RewardSettings storedRewardSettings = (RewardSettings)WalletUtils.fromJsonString((String)settingsValueString, RewardSettings.class);
        if (storedRewardSettings == null) {
            storedRewardSettings = new RewardSettings();
        }
        if ((pluginSettings = storedRewardSettings.getPluginSettings()) == null) {
            pluginSettings = new HashSet<RewardPluginSettings>();
            storedRewardSettings.setPluginSettings(pluginSettings);
        }
        if (!(configuredPluginIds = this.rewardPlugins.keySet()).isEmpty()) {
            for (String configuredPluginId : configuredPluginIds) {
                if (!pluginSettings.stream().noneMatch(plugin -> StringUtils.equals((CharSequence)plugin.getPluginId(), (CharSequence)configuredPluginId))) continue;
                RewardPluginSettings emptyRewardSettings = new RewardPluginSettings();
                emptyRewardSettings.setPluginId(configuredPluginId);
                pluginSettings.add(emptyRewardSettings);
            }
        }
        for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
            if (rewardPluginSettings == null) continue;
            String pluginId = rewardPluginSettings.getPluginId();
            RewardPlugin rewardPlugin = this.getRewardPlugin(pluginId);
            boolean enabled = false;
            if (rewardPlugin != null) {
                enabled = rewardPlugin.isEnabled();
            }
            rewardPluginSettings.setEnabled(enabled);
        }
        this.rewardSettings = storedRewardSettings;
        return this.rewardSettings;
    }

    public void saveSettings(RewardSettings rewardSettingsToStore) {
        if (rewardSettingsToStore == null) {
            throw new IllegalArgumentException("Empty settings to save");
        }
        Set pluginSettings = rewardSettingsToStore.getPluginSettings();
        if (pluginSettings != null && !pluginSettings.isEmpty()) {
            for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
                if (rewardPluginSettings.getBudgetType() != RewardBudgetType.FIXED_PER_POINT) continue;
                rewardPluginSettings.setUsePools(false);
            }
        }
        String settingsString = WalletUtils.toJsonString((Object)rewardSettingsToStore);
        this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS", SettingValue.create((String)settingsString));
        this.rewardSettings = null;
    }

    public void addRewardPeriodInProgress(RewardPeriod rewardPeriod) {
        Set<RewardPeriod> rewardPeriods = this.getRewardPeriodsInProgress();
        if (rewardPeriods == null || rewardPeriods.isEmpty()) {
            rewardPeriods = new HashSet<RewardPeriod>();
        }
        rewardPeriods.add(rewardPeriod);
        this.saveRewardPeriodInProgress(rewardPeriods);
    }

    public void saveRewardPeriodInProgress(Set<RewardPeriod> rewardPeriods) {
        String rewardPeriodString = this.toRewardPeriodString(rewardPeriods);
        if (StringUtils.isBlank((CharSequence)rewardPeriodString)) {
            this.settingService.remove(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_PERIODS_IN_PROGRESS");
        } else {
            this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_PERIODS_IN_PROGRESS", SettingValue.create((String)rewardPeriodString));
        }
    }

    public Set<RewardPeriod> getRewardPeriodsInProgress() {
        SettingValue settingsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_PERIODS_IN_PROGRESS");
        String settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        return settingsValueString == null ? Collections.emptySet() : this.toRewardPeriods(settingsValueString);
    }

    private String toRewardPeriodString(Set<RewardPeriod> rewardPeriods) {
        JSONArray jsonArray = new JSONArray();
        if (rewardPeriods == null || rewardPeriods.isEmpty()) {
            return null;
        }
        for (RewardPeriod rewardPeriod : rewardPeriods) {
            jsonArray.put((Object)WalletUtils.toJsonString((Object)rewardPeriod));
        }
        return jsonArray.toString();
    }

    private Set<RewardPeriod> toRewardPeriods(String settingsValueString) {
        try {
            JSONArray jsonArray = new JSONArray(settingsValueString);
            HashSet<RewardPeriod> rewardPeriods = new HashSet<RewardPeriod>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String rewardPeriodString = jsonArray.getString(i);
                rewardPeriods.add((RewardPeriod)WalletUtils.fromJsonString((String)rewardPeriodString, RewardPeriod.class));
            }
            return rewardPeriods;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while parsing reward periods list", e);
        }
    }

    public void registerPlugin(RewardPlugin rewardPlugin) {
        this.rewardPlugins.put(rewardPlugin.getPluginId(), rewardPlugin);
        this.rewardSettings = null;
    }

    public void unregisterPlugin(String pluginId) {
        this.rewardPlugins.remove(pluginId);
        this.rewardSettings = null;
    }

    public Collection<RewardPlugin> getRewardPlugins() {
        return this.rewardPlugins.values();
    }

    public RewardPlugin getRewardPlugin(String pluginId) {
        return this.rewardPlugins.get(pluginId);
    }

    public int getReminderDateInDays() {
        return this.reminderDateInDays;
    }
}

