/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.notification;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.utils.RewardUtils;
import org.exoplatform.wallet.utils.WalletUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class RewardSuccessTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(RewardSuccessTemplateBuilder.class);
    private ChannelKey channelKey;
    private boolean pushNotification;
    private ExoContainer container;

    public RewardSuccessTemplateBuilder(PortalContainer container, ChannelKey channelKey) {
        this.container = container;
        this.channelKey = channelKey;
        this.pushNotification = StringUtils.equals((CharSequence)channelKey.getId(), (CharSequence)"PUSH_CHANNEL");
    }

    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.channelKey, (String)pluginId, (String)language);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            templateContext.putAll(notification.getOwnerParameter());
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            String amount = (String)templateContext.get((Object)"amount");
            templateContext.put((Object)"amount", (Object)WalletUtils.formatNumber((Object)amount, (String)language));
            String rewardStartPeriodDate = (String)templateContext.get((Object)"rewardStartPeriodDate");
            templateContext.put((Object)"rewardStartPeriodDateFormatted", (Object)RewardUtils.formatTime((Object)rewardStartPeriodDate, (String)language));
            String rewardEndPeriodDate = (String)templateContext.get((Object)"rewardEndPeriodDate");
            templateContext.put((Object)"rewardEndPeriodDateFormatted", (Object)RewardUtils.formatTime((Object)(Long.parseLong(rewardEndPeriodDate) - 1L), (String)language));
            String notificationRead = notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notificationRead) != false ? "read" : "unread"));
            this.setLastModifiedDate(notification, language, templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            if (templateContext.getException() != null) {
                throw new IllegalStateException("An error occurred while building message", templateContext.getException());
            }
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.to(notification.getTo());
            messageInfo.from(notification.getFrom());
            messageInfo.pluginId(pluginId);
            if (this.pushNotification) {
                messageInfo.subject("/");
            } else {
                Object context = templateContext.remove((Object)"_ctx");
                messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext));
                templateContext.put((Object)"_ctx", context);
            }
            MessageInfo messageInfo2 = messageInfo.body(body).end();
            return messageInfo2;
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while building notification message", (Throwable)e);
            throw e;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }

    private void setLastModifiedDate(NotificationInfo notification, String language, TemplateContext templateContext) {
        try {
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            String lastModifiedDateString = TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR);
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)lastModifiedDateString);
        }
        catch (Exception e) {
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)"");
        }
    }
}

