/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.job;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.LongStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.reward.RewardBudgetType;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.reward.BaseWalletRewardTest;
import org.exoplatform.wallet.reward.api.RewardPlugin;
import org.exoplatform.wallet.reward.job.RewardStatusVerifierJob;
import org.exoplatform.wallet.reward.service.WalletRewardReportService;
import org.exoplatform.wallet.reward.service.WalletRewardSettingsService;
import org.exoplatform.wallet.reward.service.WalletRewardTeamService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.storage.WalletStorage;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class WalletRewardJobTest
extends BaseWalletRewardTest {
    @Test
    public void testGetRewardPlugins() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        Collection rewardPlugins = rewardSettingsService.getRewardPlugins();
        WalletRewardJobTest.assertEquals((int)2, (int)rewardPlugins.size());
        RewardPeriod period = RewardPeriodType.WEEK.getPeriodOfTime(LocalDate.now(), ZoneId.systemDefault());
        for (RewardPlugin rewardPlugin : rewardPlugins) {
            try {
                rewardPlugin.getEarnedPoints(Collections.singleton(1L), period.getStartDateInSeconds(), period.getEndDateInSeconds());
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendRewards() throws Exception {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        WalletRewardReportService walletRewardService = this.getService(WalletRewardReportService.class);
        WalletTokenAdminService tokenAdminService = (WalletTokenAdminService)Mockito.mock(WalletTokenAdminService.class);
        this.resetTokenAdminService(walletTransactionService, tokenAdminService, true, false);
        int contractDecimals = WalletUtils.getContractDetail().getDecimals();
        LocalDate date = YearMonth.of(2019, 7).atEndOfMonth();
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            RewardSettings newSettings = this.cloneSettings(rewardSettingsService.getSettings());
            Set newPluginSettings = newSettings.getPluginSettings();
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            RewardPluginSettings customPluginSetting = newPluginSettings.stream().filter(plugin -> "custom".equals(plugin.getPluginId())).findFirst().orElse(null);
            double sumOfTokensToSend = 5490.0;
            customPluginSetting.setUsePools(true);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            customPluginSetting.setThreshold(0.0);
            customPluginSetting.setEnabled(true);
            rewardSettingsService.saveSettings(newSettings);
            WalletStorage walletStorage = this.getService(WalletStorage.class);
            int enabledWalletsCount = 60;
            for (int i = 0; i < enabledWalletsCount; ++i) {
                Wallet wallet = this.newWallet((long)i + 1L);
                wallet = walletStorage.saveWallet(wallet, true);
                this.updateWalletBlockchainState(wallet);
                walletStorage.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
                this.entitiesToClean.add(wallet);
            }
            ArrayList<RewardTeam> teams = new ArrayList<RewardTeam>();
            RewardTeam rewardTeam1 = this.createTeamWithMembers(1, 10, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam1);
            RewardTeam rewardTeam2 = this.createTeamWithMembers(11, 20, RewardBudgetType.FIXED, false);
            teams.add(rewardTeam2);
            RewardTeam rewardTeam3 = this.createTeamWithMembers(21, 30, RewardBudgetType.FIXED_PER_MEMBER, false);
            teams.add(rewardTeam3);
            RewardTeam rewardTeam4 = this.createTeamWithMembers(31, 40, RewardBudgetType.FIXED_PER_MEMBER, false);
            teams.add(rewardTeam4);
            RewardTeam rewardTeam5 = this.createTeamWithMembers(41, 50, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam5);
            RewardTeam rewardTeam6 = this.createTeamWithMembers(51, 60, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam6);
            List initialRewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)initialRewardPeriodsInProgress);
            Mockito.when((Object)tokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend + 1L).pow(contractDecimals));
            walletRewardService.sendRewards(date, "root");
            ((WalletTokenAdminService)Mockito.verify((Object)tokenAdminService, (VerificationMode)Mockito.times((int)60))).reward((TransactionDetail)Mockito.any(), (String)Mockito.any());
            List rewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)rewardPeriodsInProgress);
            WalletRewardJobTest.assertEquals((long)((long)initialRewardPeriodsInProgress.size() + 1L), (long)rewardPeriodsInProgress.size());
            RewardStatusVerifierJob rewardReportNotificationJob = new RewardStatusVerifierJob();
            rewardReportNotificationJob.execute(null);
            rewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)rewardPeriodsInProgress);
            WalletRewardJobTest.assertEquals((long)((long)initialRewardPeriodsInProgress.size() + 1L), (long)rewardPeriodsInProgress.size());
            RewardReport rewardReport = walletRewardService.computeRewards(date);
            Set rewards = rewardReport.getRewards();
            for (WalletReward walletReward : rewards) {
                String hash = walletReward.getTransaction().getHash();
                TransactionDetail transactionDetail = walletTransactionService.getTransactionByHash(hash);
                transactionDetail.setPending(false);
                transactionDetail.setSucceeded(true);
                walletTransactionService.saveTransactionDetail(transactionDetail, true);
            }
            WalletAccountService walletAccountServiceMock = (WalletAccountService)Mockito.mock(WalletAccountService.class);
            Mockito.when((Object)walletAccountServiceMock.isAdminAccountEnabled()).thenReturn((Object)true);
            rewardReportNotificationJob.execute(null);
            rewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)rewardPeriodsInProgress);
            WalletRewardJobTest.assertEquals((int)1, (int)rewardPeriodsInProgress.size());
            rewardReportNotificationJob.walletAccountService = walletAccountServiceMock;
            Wallet adminWallet = new Wallet();
            Mockito.when((Object)walletAccountServiceMock.getAdminWallet()).thenReturn((Object)adminWallet);
            adminWallet.setEtherBalance(Double.valueOf(2.0));
            adminWallet.setTokenBalance(Double.valueOf(3.0));
            adminWallet.setEnabled(true);
            rewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)rewardPeriodsInProgress);
            WalletRewardJobTest.assertEquals((int)1, (int)rewardPeriodsInProgress.size());
            walletRewardService.setRewardSendingInProgress(true);
            rewardReportNotificationJob.execute(null);
            rewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)rewardPeriodsInProgress);
            WalletRewardJobTest.assertEquals((int)1, (int)rewardPeriodsInProgress.size());
            walletRewardService.setRewardSendingInProgress(false);
            rewardReportNotificationJob.execute(null);
            rewardPeriodsInProgress = walletRewardService.getRewardPeriodsInProgress();
            WalletRewardJobTest.assertNotNull((Object)rewardPeriodsInProgress);
            WalletRewardJobTest.assertEquals((int)0, (int)rewardPeriodsInProgress.size());
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    private void resetTokenAdminService(final WalletTransactionService walletTransactionService, WalletTokenAdminService tokenAdminService, final boolean pendingTransactions, final boolean successTransactions) throws Exception {
        if (this.container.getComponentInstanceOfType(WalletTokenAdminService.class) != null) {
            this.container.unregisterComponent(WalletTokenAdminService.class);
        }
        this.container.registerComponentInstance(WalletTokenAdminService.class, (Object)tokenAdminService);
        Mockito.reset((Object[])new WalletTokenAdminService[]{tokenAdminService});
        Mockito.when((Object)tokenAdminService.getAdminWalletAddress()).thenReturn((Object)"adminAddress");
        Mockito.when((Object)tokenAdminService.reward((TransactionDetail)Mockito.any(), (String)Mockito.any())).thenAnswer((Answer)new Answer<TransactionDetail>(){

            public TransactionDetail answer(InvocationOnMock invocation) throws Throwable {
                TransactionDetail transactionDetail = (TransactionDetail)invocation.getArgument(0, TransactionDetail.class);
                transactionDetail.setHash(WalletRewardJobTest.this.generateTransactionHash());
                transactionDetail.setPending(pendingTransactions);
                transactionDetail.setSucceeded(successTransactions);
                transactionDetail.setContractMethodName("reward");
                RequestLifeCycle.begin((ExoContainer)WalletRewardJobTest.this.container);
                try {
                    walletTransactionService.saveTransactionDetail(transactionDetail, false);
                }
                finally {
                    RequestLifeCycle.end();
                }
                WalletRewardJobTest.this.entitiesToClean.add(transactionDetail);
                return transactionDetail;
            }
        });
    }

    private RewardTeam createTeamWithMembers(int startInclusive, int endInclusive, RewardBudgetType budgetType, boolean disabled) {
        WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
        long[] memberIds = LongStream.rangeClosed(startInclusive, endInclusive).toArray();
        RewardTeam rewardTeam = this.newRewardTeam(memberIds);
        rewardTeam.setName("Name" + startInclusive);
        rewardTeam.setDisabled(disabled);
        rewardTeam.setRewardType(budgetType);
        double totalBudget = (double)LongStream.rangeClosed(startInclusive, endInclusive).sum() * 3.0;
        if (budgetType == RewardBudgetType.COMPUTED || budgetType == RewardBudgetType.FIXED) {
            rewardTeam.setBudget(Double.valueOf(totalBudget));
        } else {
            rewardTeam.setBudget(Double.valueOf(totalBudget / (double)memberIds.length));
        }
        rewardTeam = rewardTeamService.saveTeam(rewardTeam);
        this.entitiesToClean.add(rewardTeam);
        return rewardTeam;
    }
}

