/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.service;

import java.util.List;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.RewardTeamMember;
import org.exoplatform.wallet.reward.BaseWalletRewardTest;
import org.exoplatform.wallet.reward.service.WalletRewardTeamService;
import org.junit.Test;

public class WalletRewardTeamServiceTest
extends BaseWalletRewardTest {
    @Test
    public void testServiceInstantiated() {
        WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
        WalletRewardTeamServiceTest.assertNotNull((Object)rewardTeamService);
    }

    @Test
    public void testGetTeams() {
        WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
        List teams = rewardTeamService.getTeams();
        WalletRewardTeamServiceTest.assertNotNull((Object)teams);
        WalletRewardTeamServiceTest.assertEquals((int)0, (int)teams.size());
    }

    @Test
    public void testSaveTeam() {
        WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
        RewardTeam rewardTeam = this.newRewardTeam();
        rewardTeam = rewardTeamService.saveTeam(rewardTeam);
        this.entitiesToClean.add(rewardTeam);
        List teams = rewardTeamService.getTeams();
        WalletRewardTeamServiceTest.assertEquals((int)1, (int)teams.size());
        RewardTeam savedTeam = (RewardTeam)teams.iterator().next();
        WalletRewardTeamServiceTest.assertNotNull((Object)savedTeam.getId());
        WalletRewardTeamServiceTest.assertTrue((savedTeam.getId() > 0L ? 1 : 0) != 0);
        WalletRewardTeamServiceTest.assertEquals((String)"name", (String)savedTeam.getName());
        WalletRewardTeamServiceTest.assertEquals((String)"Team description", (String)savedTeam.getDescription());
        WalletRewardTeamServiceTest.assertNull((Object)savedTeam.getSpaceId());
        WalletRewardTeamServiceTest.assertEquals((double)2.0, (double)savedTeam.getBudget(), (double)0.0);
        WalletRewardTeamServiceTest.assertEquals((Object)TEAM_BUDGET_TYPE, (Object)savedTeam.getRewardType());
        WalletRewardTeamServiceTest.assertNotNull((Object)savedTeam.getManager());
        WalletRewardTeamServiceTest.assertEquals((float)1.0f, (float)savedTeam.getManager().getIdentityId().longValue(), (float)0.0f);
        WalletRewardTeamServiceTest.assertNotNull((Object)savedTeam.getMembers());
        WalletRewardTeamServiceTest.assertEquals((int)1, (int)savedTeam.getMembers().size());
        WalletRewardTeamServiceTest.assertNotNull(savedTeam.getMembers().get(0));
        WalletRewardTeamServiceTest.assertEquals((float)2.0f, (float)((RewardTeamMember)savedTeam.getMembers().get(0)).getIdentityId().longValue(), (float)0.0f);
    }

    @Test
    public void testRemoveTeam() {
        WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
        RewardTeam rewardTeam = this.newRewardTeam();
        rewardTeam = rewardTeamService.saveTeam(rewardTeam);
        WalletRewardTeamServiceTest.assertFalse((boolean)rewardTeam.isDeleted());
        List teams = rewardTeamService.getTeams();
        WalletRewardTeamServiceTest.assertEquals((int)1, (int)teams.size());
        rewardTeamService.removeTeam(rewardTeam.getId());
        teams = rewardTeamService.getTeams();
        WalletRewardTeamServiceTest.assertEquals((int)0, (int)teams.size());
        rewardTeam = rewardTeamService.getTeamsById(rewardTeam.getId().longValue());
        WalletRewardTeamServiceTest.assertTrue((boolean)rewardTeam.isDeleted());
        this.entitiesToClean.add(rewardTeam);
    }
}

