/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.notification;

import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParam;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.reward.BaseWalletRewardTest;
import org.exoplatform.wallet.reward.notification.RewardSuccessNotificationPlugin;
import org.exoplatform.wallet.utils.RewardUtils;
import org.junit.Test;

public class RewardSuccessNotificationPluginTest
extends BaseWalletRewardTest {
    @Test
    public void testMakeMessage() {
        RewardSuccessNotificationPlugin plugin = new RewardSuccessNotificationPlugin(this.getParams());
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        RewardReport rewardReport = new RewardReport();
        RewardPeriod rewardPeriod = RewardPeriod.getCurrentPeriod((RewardSettings)RewardUtils.getRewardSettings());
        rewardReport.setPeriod(rewardPeriod);
        HashSet<WalletReward> rewards = new HashSet<WalletReward>();
        for (int i = 0; i < 30; ++i) {
            TransactionDetail transaction = new TransactionDetail();
            transaction.setHash("hash");
            transaction.setContractAmount(2.0);
            transaction.setPending(true);
            rewards.add(new WalletReward(null, null, transaction, null, null));
        }
        rewardReport.setRewards(rewards);
        ctx.append(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM, (Object)rewardReport);
        RewardSuccessNotificationPluginTest.assertTrue((boolean)plugin.isValid(ctx));
        NotificationInfo notification = plugin.buildNotification(ctx);
        RewardSuccessNotificationPluginTest.assertNotNull((Object)notification);
        RewardSuccessNotificationPluginTest.assertEquals((String)String.valueOf(rewardReport.getFailedTransactionCount()), (String)notification.getValueOwnerParameter("rewardFailCount"));
        RewardSuccessNotificationPluginTest.assertEquals((String)String.valueOf(rewardReport.getSuccessTransactionCount()), (String)notification.getValueOwnerParameter("rewardSuccessCount"));
        RewardSuccessNotificationPluginTest.assertEquals((String)String.valueOf(rewardReport.getPendingTransactionCount()), (String)notification.getValueOwnerParameter("rewardPendingCount"));
        RewardSuccessNotificationPluginTest.assertEquals((String)String.valueOf(rewardReport.getTransactionsCount()), (String)notification.getValueOwnerParameter("rewardTransactionCount"));
        RewardSuccessNotificationPluginTest.assertEquals((String)String.valueOf(rewardReport.getValidRewardCount()), (String)notification.getValueOwnerParameter("rewardValidMembersCount"));
        RewardSuccessNotificationPluginTest.assertEquals((String)String.valueOf(rewardReport.getTokensSent()), (String)notification.getValueOwnerParameter("amount"));
    }

    private InitParams getParams() {
        InitParams initParams = new InitParams();
        ObjectParam objectParam = new ObjectParam();
        objectParam.setName("plugin-config");
        objectParam.setType(PluginConfig.class.getName());
        objectParam.addProperty("pluginId", "RewardSuccessNotificationPlugin");
        objectParam.addProperty("resourceBundleKey", "UINotification.label.RewardSuccessNotificationPlugin");
        objectParam.addProperty("order", "1");
        objectParam.addProperty("groupId", "wallet");
        objectParam.addProperty("bundlePath", "locale.notification.WalletNotification");
        initParams.addParam((Object)objectParam);
        return initParams;
    }
}

