/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.wallet.model.reward.RewardBudgetType;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.reward.BaseWalletRewardTest;
import org.exoplatform.wallet.reward.api.RewardPlugin;
import org.exoplatform.wallet.reward.service.WalletRewardSettingsService;
import org.junit.Test;

public class WalletRewardSettingsServiceTest
extends BaseWalletRewardTest {
    @Test
    public void testServiceInstantiated() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        WalletRewardSettingsServiceTest.assertNotNull((Object)rewardSettingsService);
    }

    @Test
    public void tetGetRewardPlugins() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        Collection rewardPlugins = rewardSettingsService.getRewardPlugins();
        WalletRewardSettingsServiceTest.assertNotNull((String)"List of rewards plugins shouldn't be null", (Object)rewardPlugins);
        WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugins count", (int)2, (int)rewardPlugins.size());
    }

    @Test
    public void tetGetRewardPlugin() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        String pluginId = "kudos";
        RewardPlugin kudosRewardPlugin = rewardSettingsService.getRewardPlugin(pluginId);
        WalletRewardSettingsServiceTest.assertNotNull((String)"Rewards plugin 'kudos' shouldn't be null", (Object)kudosRewardPlugin);
        WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin name", (String)pluginId, (String)kudosRewardPlugin.getName());
        WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin id", (String)pluginId, (String)kudosRewardPlugin.getPluginId());
        Map earnedPoints = kudosRewardPlugin.getEarnedPoints(Collections.emptySet(), 0L, Long.MAX_VALUE);
        WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin earned points", new HashMap(), (Object)earnedPoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterPlugin() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            RewardPlugin registeredRewardPlugin = rewardSettingsService.getRewardPlugin("custom");
            WalletRewardSettingsServiceTest.assertNotNull((String)"Rewards plugin 'kudos' shouldn't be null", (Object)registeredRewardPlugin);
            WalletRewardSettingsServiceTest.assertEquals((String)"Returned rewards plugin isn't the same as the registered one", (Object)CUSTOM_REWARD_PLUGIN, (Object)registeredRewardPlugin);
            WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin name", (String)"plugin name", (String)CUSTOM_REWARD_PLUGIN.getName());
            WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin id", (String)"custom", (String)CUSTOM_REWARD_PLUGIN.getPluginId());
            WalletRewardSettingsServiceTest.assertTrue((String)"Reward plugin should be enabled by default", (boolean)CUSTOM_REWARD_PLUGIN.isEnabled());
            HashSet<Long> identityIds = new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L));
            Map<Long, Double> expectedRewards = WalletRewardSettingsServiceTest.getEarnedPoints(identityIds);
            Map earnedPoints = CUSTOM_REWARD_PLUGIN.getEarnedPoints(identityIds, 0L, Long.MAX_VALUE);
            WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin earned points", expectedRewards, (Object)earnedPoints);
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
        }
    }

    @Test
    public void testGetSettings() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        WalletRewardSettingsServiceTest.assertNotNull((Object)defaultSettings);
        WalletRewardSettingsServiceTest.assertEquals((String)"Wrong default reward period type", (Object)RewardPeriodType.DEFAULT, (Object)defaultSettings.getPeriodType());
        Set pluginSettings = defaultSettings.getPluginSettings();
        WalletRewardSettingsServiceTest.assertNotNull((String)"List of rewards plugin settings shouldn't be null", (Object)pluginSettings);
        WalletRewardSettingsServiceTest.assertEquals((String)"Unexpected reward plugin settings count", (int)2, (int)pluginSettings.size());
        RewardPluginSettings rewardPluginSettings = (RewardPluginSettings)pluginSettings.iterator().next();
        WalletRewardSettingsServiceTest.assertNotNull((Object)rewardPluginSettings);
        WalletRewardSettingsServiceTest.assertEquals((double)0.0, (double)rewardPluginSettings.getAmount(), (double)0.0);
        WalletRewardSettingsServiceTest.assertEquals((Object)RewardBudgetType.DEFAULT, (Object)rewardPluginSettings.getBudgetType());
        WalletRewardSettingsServiceTest.assertEquals((double)0.0, (double)rewardPluginSettings.getThreshold(), (double)0.0);
        WalletRewardSettingsServiceTest.assertFalse((boolean)rewardPluginSettings.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveSettings() {
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        RewardSettings newSettings = this.cloneSettings(defaultSettings);
        Set newPluginSettings = newSettings.getPluginSettings();
        long amount = 1L;
        boolean enabled = true;
        boolean usePools = true;
        long threshold = 2L;
        RewardBudgetType budgetType = RewardBudgetType.FIXED_PER_POINT;
        RewardPeriodType periodType = RewardPeriodType.SEMESTER;
        newSettings.setPeriodType(periodType);
        for (RewardPluginSettings pluginSetting : newPluginSettings) {
            pluginSetting.setAmount((double)amount);
            pluginSetting.setBudgetType(budgetType);
            pluginSetting.setEnabled(enabled);
            pluginSetting.setThreshold((double)threshold);
            pluginSetting.setUsePools(usePools);
        }
        rewardSettingsService.saveSettings(newSettings);
        try {
            newSettings = rewardSettingsService.getSettings();
            WalletRewardSettingsServiceTest.assertNotNull((Object)newSettings);
            WalletRewardSettingsServiceTest.assertEquals((Object)periodType, (Object)newSettings.getPeriodType());
            newPluginSettings = newSettings.getPluginSettings();
            for (RewardPluginSettings pluginSetting : newPluginSettings) {
                WalletRewardSettingsServiceTest.assertEquals((double)amount, (double)pluginSetting.getAmount(), (double)0.0);
                WalletRewardSettingsServiceTest.assertEquals((double)threshold, (double)pluginSetting.getThreshold(), (double)0.0);
                WalletRewardSettingsServiceTest.assertFalse((String)"Enablement should be retrieved always from registered plugin and not from storage", (boolean)pluginSetting.isEnabled());
                WalletRewardSettingsServiceTest.assertEquals((Object)budgetType, (Object)pluginSetting.getBudgetType());
                WalletRewardSettingsServiceTest.assertFalse((String)"Pools can't be used when budget type equals to 'FIXED_PER_POINT'", (boolean)pluginSetting.isUsePools());
            }
            budgetType = RewardBudgetType.FIXED;
            for (RewardPluginSettings pluginSetting : newPluginSettings) {
                pluginSetting.setBudgetType(budgetType);
                pluginSetting.setUsePools(usePools);
            }
            rewardSettingsService.saveSettings(newSettings);
            newSettings = rewardSettingsService.getSettings();
            newPluginSettings = newSettings.getPluginSettings();
            for (RewardPluginSettings pluginSetting : newPluginSettings) {
                WalletRewardSettingsServiceTest.assertEquals((Object)budgetType, (Object)pluginSetting.getBudgetType());
                WalletRewardSettingsServiceTest.assertTrue((String)"Pools should be saved using new value 'true' when budget type is set to 'FIXED'", (boolean)pluginSetting.isUsePools());
            }
        }
        finally {
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }
}

