/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.service;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.LongStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.reward.RewardBudgetType;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.model.reward.RewardStatus;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.WalletPluginReward;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.reward.BaseWalletRewardTest;
import org.exoplatform.wallet.reward.dao.RewardDAO;
import org.exoplatform.wallet.reward.dao.RewardPeriodDAO;
import org.exoplatform.wallet.reward.entity.WalletRewardEntity;
import org.exoplatform.wallet.reward.entity.WalletRewardPeriodEntity;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.exoplatform.wallet.reward.service.RewardTeamService;
import org.exoplatform.wallet.reward.service.WalletRewardReportService;
import org.exoplatform.wallet.reward.service.WalletRewardSettingsService;
import org.exoplatform.wallet.reward.service.WalletRewardTeamService;
import org.exoplatform.wallet.reward.storage.WalletRewardReportStorage;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.RewardUtils;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class WalletRewardReportServiceTest
extends BaseWalletRewardTest {
    @Test
    public void testServiceInstantiated() {
        WalletRewardReportService walletRewardService = this.getService(WalletRewardReportService.class);
        WalletRewardReportServiceTest.assertNotNull((Object)walletRewardService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComputeRewards() {
        WalletRewardReportService walletRewardService = this.getService(WalletRewardReportService.class);
        LocalDate date = YearMonth.of(2019, 3).atEndOfMonth();
        RewardReport rewardReport = walletRewardService.computeRewards(date);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport.getRewards());
        WalletRewardReportServiceTest.assertEquals((int)0, (int)rewardReport.getRewards().size());
        WalletAccountService accountService = this.getService(WalletAccountService.class);
        int enabledWalletsCount = 60;
        for (int i = 0; i < enabledWalletsCount; ++i) {
            Wallet wallet = this.newWallet((long)i + 1L);
            wallet = accountService.saveWallet(wallet, true);
            this.updateWalletBlockchainState(wallet);
            accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
            this.entitiesToClean.add(wallet);
        }
        rewardReport = walletRewardService.computeRewards(date);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
        WalletRewardReportServiceTest.assertEquals((int)enabledWalletsCount, (int)rewardReport.getRewards().size());
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            RewardSettings newSettings = this.cloneSettings(rewardSettingsService.getSettings());
            Set newPluginSettings = newSettings.getPluginSettings();
            long amount = 3L;
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            RewardPluginSettings customPluginSetting = newPluginSettings.stream().filter(plugin -> "custom".equals(plugin.getPluginId())).findFirst().orElse(null);
            WalletRewardReportServiceTest.assertNotNull((Object)customPluginSetting);
            customPluginSetting.setAmount((double)amount);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED_PER_POINT);
            customPluginSetting.setThreshold(0.0);
            customPluginSetting.setEnabled(true);
            customPluginSetting.setUsePools(false);
            rewardSettingsService.saveSettings(newSettings);
            double sumOfTokensToSend = this.checkComputedRewards(walletRewardService, date, enabledWalletsCount, amount);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            rewardSettingsService.saveSettings(newSettings);
            this.checkComputedRewards(walletRewardService, date, enabledWalletsCount, amount);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED_PER_MEMBER);
            customPluginSetting.setAmount(sumOfTokensToSend / (double)enabledWalletsCount);
            rewardSettingsService.saveSettings(newSettings);
            this.checkComputedRewards(walletRewardService, date, enabledWalletsCount, amount);
            customPluginSetting.setThreshold(31.0);
            customPluginSetting.setAmount((double)amount);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED_PER_POINT);
            rewardSettingsService.saveSettings(newSettings);
            this.checkComputedRewards(walletRewardService, date, 30, amount);
            customPluginSetting.setThreshold(0.0);
            rewardSettingsService.saveSettings(newSettings);
            RewardTeam rewardTeam1 = this.createTeamWithMembers(1, 10, RewardBudgetType.COMPUTED, true);
            RewardTeam rewardTeam2 = this.createTeamWithMembers(11, 20, RewardBudgetType.FIXED, true);
            RewardTeam rewardTeam3 = this.createTeamWithMembers(21, 30, RewardBudgetType.FIXED_PER_MEMBER, true);
            RewardTeam rewardTeam4 = this.createTeamWithMembers(31, 40, RewardBudgetType.FIXED_PER_MEMBER, true);
            RewardTeam rewardTeam5 = this.createTeamWithMembers(41, 50, RewardBudgetType.COMPUTED, true);
            RewardTeam rewardTeam6 = this.createTeamWithMembers(51, 60, RewardBudgetType.COMPUTED, true);
            ArrayList<RewardTeam> teams = new ArrayList<RewardTeam>();
            teams.add(rewardTeam1);
            teams.add(rewardTeam2);
            teams.add(rewardTeam3);
            teams.add(rewardTeam4);
            teams.add(rewardTeam5);
            teams.add(rewardTeam6);
            this.checkComputedRewards(walletRewardService, date, enabledWalletsCount, amount);
            customPluginSetting.setUsePools(true);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            rewardSettingsService.saveSettings(newSettings);
            this.checkComputedRewards(walletRewardService, date, 0, 0L);
            WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
            teams.forEach(team -> {
                team.setDisabled(false);
                rewardTeamService.saveTeam(team);
            });
            rewardReport = walletRewardService.computeRewards(date);
            double tokensToSend = rewardReport.getRewards().stream().mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)sumOfTokensToSend, (double)tokensToSend, (double)0.0);
            double tokensSentToTeam2 = rewardReport.getRewards().stream().filter(walletReward -> walletReward.getTeam() != null && rewardTeam2.getId().equals(walletReward.getTeam().getId())).mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)rewardTeam2.getBudget(), (double)tokensSentToTeam2, (double)0.0);
            double tokensSentToTeam3 = rewardReport.getRewards().stream().filter(walletReward -> walletReward.getTeam() != null && rewardTeam3.getId().equals(walletReward.getTeam().getId())).mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)(rewardTeam3.getBudget() * (double)rewardTeam3.getMembers().size()), (double)tokensSentToTeam3, (double)0.0);
            double tokensSentToTeam4 = rewardReport.getRewards().stream().filter(walletReward -> walletReward.getTeam() != null && rewardTeam4.getId().equals(walletReward.getTeam().getId())).mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)(rewardTeam4.getBudget() * (double)rewardTeam4.getMembers().size()), (double)tokensSentToTeam4, (double)0.0);
            double tokensSentToOtherTeams = sumOfTokensToSend - tokensSentToTeam2 - tokensSentToTeam3 - tokensSentToTeam4;
            double tokensSentToOtherTeam = tokensSentToOtherTeams / 3.0;
            double tokensSentToTeam1 = rewardReport.getRewards().stream().filter(walletReward -> walletReward.getTeam() != null && rewardTeam1.getId().equals(walletReward.getTeam().getId())).mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)tokensSentToOtherTeam, (double)tokensSentToTeam1, (double)0.0);
            double tokensSentToTeam5 = rewardReport.getRewards().stream().filter(walletReward -> walletReward.getTeam() != null && rewardTeam5.getId().equals(walletReward.getTeam().getId())).mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)tokensSentToOtherTeam, (double)tokensSentToTeam5, (double)0.0);
            double tokensSentToTeam6 = rewardReport.getRewards().stream().filter(walletReward -> walletReward.getTeam() != null && rewardTeam6.getId().equals(walletReward.getTeam().getId())).mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)tokensSentToOtherTeam, (double)tokensSentToTeam6, (double)0.0);
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComputeRewardWithDuplication() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        WalletRewardReportService walletRewardService = this.getService(WalletRewardReportService.class);
        LocalDate date = YearMonth.of(2019, 3).atEndOfMonth();
        RewardReport rewardReport = walletRewardService.computeRewards(date);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport.getRewards());
        WalletRewardReportServiceTest.assertEquals((int)0, (int)rewardReport.getRewards().size());
        WalletAccountService accountService = this.getService(WalletAccountService.class);
        int enabledWalletsCount = 60;
        for (int i = 0; i < enabledWalletsCount; ++i) {
            Wallet wallet = this.newWallet((long)i + 1L);
            wallet = accountService.saveWallet(wallet, true);
            this.updateWalletBlockchainState(wallet);
            accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
            this.entitiesToClean.add(wallet);
        }
        rewardReport = walletRewardService.computeRewards(date);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
        WalletRewardReportServiceTest.assertEquals((int)enabledWalletsCount, (int)rewardReport.getRewards().size());
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            WalletRewardEntity rewardEntity;
            RewardSettings newSettings = this.cloneSettings(rewardSettingsService.getSettings());
            Set newPluginSettings = newSettings.getPluginSettings();
            long amount = 3L;
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            RewardPluginSettings customPluginSetting = newPluginSettings.stream().filter(plugin -> "custom".equals(plugin.getPluginId())).findFirst().orElse(null);
            WalletRewardReportServiceTest.assertNotNull((Object)customPluginSetting);
            customPluginSetting.setAmount((double)amount);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED_PER_POINT);
            customPluginSetting.setThreshold(0.0);
            customPluginSetting.setEnabled(true);
            customPluginSetting.setUsePools(false);
            rewardSettingsService.saveSettings(newSettings);
            double sumOfTokensToSend = this.checkComputedRewards(walletRewardService, date, enabledWalletsCount, amount);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            rewardSettingsService.saveSettings(newSettings);
            rewardReport = walletRewardService.computeRewards(date);
            double tokensToSend = rewardReport.getRewards().stream().mapToDouble(WalletReward::getTokensToSend).sum();
            WalletRewardReportServiceTest.assertEquals((double)sumOfTokensToSend, (double)tokensToSend, (double)0.0);
            Set rewards = rewardReport.getRewards();
            RewardPeriod period = rewardReport.getPeriod();
            RewardPeriodDAO rewardPeriodDAO = this.getService(RewardPeriodDAO.class);
            WalletRewardPeriodEntity rewardPeriodEntity = rewardPeriodDAO.findRewardPeriodByTypeAndTime(period.getRewardPeriodType(), period.getPeriodMedianDateInSeconds());
            if (rewardPeriodEntity == null) {
                rewardPeriodEntity = new WalletRewardPeriodEntity();
                rewardPeriodEntity.setPeriodType(period.getRewardPeriodType());
                rewardPeriodEntity.setStatus(RewardStatus.PENDING);
                rewardPeriodEntity.setStartTime(period.getStartDateInSeconds());
                rewardPeriodEntity.setEndTime(period.getEndDateInSeconds());
                rewardPeriodEntity.setTimeZone(period.getTimeZone());
                rewardPeriodEntity = (WalletRewardPeriodEntity)rewardPeriodDAO.create((Object)rewardPeriodEntity);
            }
            for (WalletReward walletReward : rewards) {
                rewardEntity = new WalletRewardEntity();
                rewardEntity.setEnabled(true);
                rewardEntity.setIdentityId(walletReward.getIdentityId());
                rewardEntity.setTokensToSend(walletReward.getTokensToSend());
                rewardEntity.setPeriod(rewardPeriodEntity);
                rewardEntity = (WalletRewardEntity)this.getService(RewardDAO.class).create((Object)rewardEntity);
            }
            this.restartTransaction();
            rewardReport = walletRewardService.computeRewards(date);
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getTokensSent(), (double)0.0);
            WalletRewardReportServiceTest.assertFalse((boolean)rewardReport.isCompletelyProceeded());
            for (WalletReward walletReward : rewards) {
                rewardEntity = new WalletRewardEntity();
                rewardEntity.setEnabled(true);
                rewardEntity.setIdentityId(walletReward.getIdentityId());
                rewardEntity.setTokensToSend(walletReward.getTokensToSend());
                rewardEntity.setPeriod(rewardPeriodEntity);
                rewardEntity.setTokensSent(tokensToSend);
                TransactionDetail transactionDetail = this.createWalltRewardTransaction(walletTransactionService, walletReward);
                rewardEntity.setTransactionHash(transactionDetail.getHash());
                rewardEntity = (WalletRewardEntity)this.getService(RewardDAO.class).create((Object)rewardEntity);
            }
            this.restartTransaction();
            rewardReport = walletRewardService.computeRewards(date);
            WalletRewardReportServiceTest.assertEquals((double)rewardReport.getTokensToSend(), (double)rewardReport.getTokensSent(), (double)0.0);
            WalletRewardReportServiceTest.assertTrue((boolean)rewardReport.isCompletelyProceeded());
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    @Test
    public void testComputeRewardsByUser() {
        WalletAccountService accountService = this.getService(WalletAccountService.class);
        Wallet userWallet = this.newWallet(1L);
        userWallet = accountService.saveWallet(userWallet, true);
        this.updateWalletBlockchainState(userWallet);
        accountService.saveWalletBlockchainState(userWallet, WalletUtils.getContractAddress());
        this.entitiesToClean.add(userWallet);
        int enabledWalletsCount = 6;
        for (int i = 1; i < enabledWalletsCount; ++i) {
            Wallet wallet = this.newWallet((long)i + 1L);
            wallet = accountService.saveWallet(wallet, true);
            this.updateWalletBlockchainState(wallet);
            accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
            this.entitiesToClean.add(wallet);
        }
        WalletRewardReportService walletRewardService = this.getService(WalletRewardReportService.class);
        LocalDate date = YearMonth.of(2022, 12).atEndOfMonth();
        RewardReport rewardReport = walletRewardService.computeRewardsByUser(date, userWallet.getTechnicalId());
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport.getRewards());
        WalletRewardReportServiceTest.assertEquals((int)1, (int)rewardReport.getRewards().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComputeRewardsWithTimeZoneChange() throws Exception {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        WalletRewardReportStorage rewardReportStorage = this.getService(WalletRewardReportStorage.class);
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardTeamService rewardTeamService = this.getService(RewardTeamService.class);
        WalletRewardReportService walletRewardService = new WalletRewardReportService(walletAccountService, (RewardSettingsService)rewardSettingsService, rewardTeamService, rewardReportStorage);
        WalletTokenAdminService tokenAdminService = (WalletTokenAdminService)Mockito.mock(WalletTokenAdminService.class);
        this.resetTokenAdminService(walletTransactionService, tokenAdminService, false, true);
        WalletAccountService accountService = this.getService(WalletAccountService.class);
        int enabledWalletsCount = 60;
        for (int i = 0; i < enabledWalletsCount; ++i) {
            Wallet wallet = this.newWallet((long)i + 1L);
            wallet = accountService.saveWallet(wallet, true);
            this.updateWalletBlockchainState(wallet);
            accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
            this.entitiesToClean.add(wallet);
        }
        LocalDate previousMonthDate = LocalDate.of(2022, 3, 1);
        LocalDate currentMonthDate = LocalDate.of(2022, 4, 1);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            RewardReport rewardReport = walletRewardService.computeRewards(previousMonthDate);
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getRemainingTokensToSend(), (double)0.0);
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getTokensSent(), (double)0.0);
            RewardSettings newSettings = this.cloneSettings(rewardSettingsService.getSettings());
            newSettings.setTimeZone("GMT");
            Set newPluginSettings = newSettings.getPluginSettings();
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            RewardPluginSettings customPluginSetting = newPluginSettings.stream().filter(plugin -> "custom".equals(plugin.getPluginId())).findFirst().orElse(null);
            double sumOfTokensToSend = 5490.0;
            customPluginSetting.setUsePools(false);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            customPluginSetting.setThreshold(0.0);
            customPluginSetting.setEnabled(true);
            rewardSettingsService.saveSettings(newSettings);
            rewardReport = walletRewardService.computeRewards(previousMonthDate);
            WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
            WalletRewardReportServiceTest.assertNotNull((Object)rewardReport.getRewards());
            WalletRewardReportServiceTest.assertEquals((int)enabledWalletsCount, (int)rewardReport.getRewards().size());
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getTokensSent(), (double)0.0);
            WalletRewardReportServiceTest.assertEquals((double)sumOfTokensToSend, (double)rewardReport.getRemainingTokensToSend(), (double)0.0);
            int contractDecimals = WalletUtils.getContractDetail().getDecimals();
            Mockito.when((Object)tokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend).pow(contractDecimals));
            walletRewardService.sendRewards(previousMonthDate, "root");
            rewardReport = walletRewardService.computeRewards(previousMonthDate);
            WalletRewardReportServiceTest.assertEquals((double)sumOfTokensToSend, (double)rewardReport.getTokensSent(), (double)0.0);
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getRemainingTokensToSend(), (double)0.0);
            rewardReport = walletRewardService.computeRewards(currentMonthDate);
            WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
            WalletRewardReportServiceTest.assertNotNull((Object)rewardReport.getRewards());
            WalletRewardReportServiceTest.assertEquals((int)enabledWalletsCount, (int)rewardReport.getRewards().size());
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getTokensSent(), (double)0.0);
            WalletRewardReportServiceTest.assertEquals((double)sumOfTokensToSend, (double)rewardReport.getRemainingTokensToSend(), (double)0.0);
            newSettings.setTimeZone("Europe/Paris");
            rewardSettingsService.saveSettings(newSettings);
            rewardReport = walletRewardService.computeRewards(currentMonthDate);
            WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
            WalletRewardReportServiceTest.assertNotNull((Object)rewardReport.getRewards());
            WalletRewardReportServiceTest.assertEquals((int)enabledWalletsCount, (int)rewardReport.getRewards().size());
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)rewardReport.getTokensSent(), (double)0.0);
            WalletRewardReportServiceTest.assertEquals((double)sumOfTokensToSend, (double)rewardReport.getRemainingTokensToSend(), (double)0.0);
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendRewards() throws Exception {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardTeamService rewardTeamService = this.getService(RewardTeamService.class);
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        WalletRewardReportStorage rewardReportStorage = this.getService(WalletRewardReportStorage.class);
        WalletRewardReportService walletRewardService = new WalletRewardReportService(walletAccountService, (RewardSettingsService)rewardSettingsService, rewardTeamService, rewardReportStorage);
        WalletTokenAdminService tokenAdminService = (WalletTokenAdminService)Mockito.mock(WalletTokenAdminService.class);
        this.resetTokenAdminService(walletTransactionService, tokenAdminService, false, true);
        int contractDecimals = WalletUtils.getContractDetail().getDecimals();
        LocalDate date = YearMonth.of(2019, 4).atEndOfMonth();
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            RewardSettings newSettings = this.cloneSettings(rewardSettingsService.getSettings());
            Set newPluginSettings = newSettings.getPluginSettings();
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            RewardPluginSettings customPluginSetting = newPluginSettings.stream().filter(plugin -> "custom".equals(plugin.getPluginId())).findFirst().orElse(null);
            double sumOfTokensToSend = 5490.0;
            customPluginSetting.setUsePools(true);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            customPluginSetting.setThreshold(0.0);
            customPluginSetting.setEnabled(true);
            rewardSettingsService.saveSettings(newSettings);
            WalletAccountService accountService = this.getService(WalletAccountService.class);
            int enabledWalletsCount = 60;
            for (int i = 0; i < enabledWalletsCount; ++i) {
                Wallet wallet = this.newWallet((long)i + 1L);
                wallet = accountService.saveWallet(wallet, true);
                this.updateWalletBlockchainState(wallet);
                accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
                this.entitiesToClean.add(wallet);
            }
            ArrayList<RewardTeam> teams = new ArrayList<RewardTeam>();
            RewardTeam rewardTeam1 = this.createTeamWithMembers(1, 10, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam1);
            RewardTeam rewardTeam2 = this.createTeamWithMembers(11, 20, RewardBudgetType.FIXED, false);
            teams.add(rewardTeam2);
            RewardTeam rewardTeam3 = this.createTeamWithMembers(21, 30, RewardBudgetType.FIXED_PER_MEMBER, false);
            teams.add(rewardTeam3);
            RewardTeam rewardTeam4 = this.createTeamWithMembers(31, 40, RewardBudgetType.FIXED_PER_MEMBER, false);
            teams.add(rewardTeam4);
            RewardTeam rewardTeam5 = this.createTeamWithMembers(41, 50, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam5);
            RewardTeam rewardTeam6 = this.createTeamWithMembers(51, 60, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam6);
            Mockito.when((Object)tokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf(10L).pow(contractDecimals));
            try {
                walletRewardService.sendRewards(date, "root");
                WalletRewardReportServiceTest.fail((String)"Shouldn't send funds when admin not having enough funds");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((WalletTokenAdminService)Mockito.verify((Object)tokenAdminService, (VerificationMode)Mockito.times((int)0))).reward((TransactionDetail)Mockito.any(), (String)Mockito.any());
            Mockito.when((Object)tokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend + 1L).pow(contractDecimals));
            walletRewardService.sendRewards(date, "root");
            ((WalletTokenAdminService)Mockito.verify((Object)tokenAdminService, (VerificationMode)Mockito.times((int)60))).reward((TransactionDetail)Mockito.any(), (String)Mockito.any());
            this.resetTokenAdminService(walletTransactionService, tokenAdminService, false, true);
            Mockito.when((Object)tokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend + 1L).pow(contractDecimals));
            try {
                walletRewardService.sendRewards(date, "root");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((WalletTokenAdminService)Mockito.verify((Object)tokenAdminService, (VerificationMode)Mockito.times((int)0))).reward((TransactionDetail)Mockito.any(), (String)Mockito.any());
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    @Test
    public void testSaveRewardReport() {
        RewardReport rewardReport = new RewardReport();
        LocalDate date = LocalDate.now();
        WalletAccountService accountService = this.getService(WalletAccountService.class);
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        RewardPeriod period = defaultSettings.getPeriodType().getPeriodOfTime(date, ZoneId.systemDefault());
        rewardReport.setPeriod(period);
        HashSet<WalletReward> rewards = new HashSet<WalletReward>();
        for (int i = 0; i < 20; ++i) {
            Wallet wallet = this.newWallet((long)i + 1L);
            wallet = accountService.saveWallet(wallet, true);
            this.updateWalletBlockchainState(wallet);
            accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
            this.entitiesToClean.add(wallet);
            WalletReward walletReward = new WalletReward();
            walletReward.setWallet(wallet);
            walletReward.setPeriod(period);
            HashSet<WalletPluginReward> pluginRewards = new HashSet<WalletPluginReward>();
            for (int j = 0; j < 10; ++j) {
                WalletPluginReward pluginReward = new WalletPluginReward();
                pluginReward.setAmount(5.0);
                pluginReward.setIdentityId(wallet.getTechnicalId());
                pluginReward.setPluginId("plugin" + j);
                pluginReward.setPoints(5.0);
                pluginReward.setPoolsUsed(false);
                pluginRewards.add(pluginReward);
            }
            walletReward.setRewards(pluginRewards);
            rewards.add(walletReward);
        }
        rewardReport.setRewards(rewards);
        RewardReportService rewardReportService = this.getService(RewardReportService.class);
        rewardReportService.saveRewardReport(rewardReport);
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)this.container);
        RewardReport savedRewardReport = rewardReportService.getRewardReport(date);
        WalletRewardReportServiceTest.assertEquals((Object)rewardReport, (Object)savedRewardReport);
        RewardPeriod rewardPeriod = rewardReportService.getRewardPeriod(period.getRewardPeriodType(), period.getPeriodMedianDate());
        WalletRewardReportServiceTest.assertNotNull((Object)rewardPeriod);
        WalletRewardReportServiceTest.assertTrue((rewardPeriod.getId() > 0L ? 1 : 0) != 0);
        RewardReport report = rewardReportService.getRewardReportByPeriodId(rewardPeriod.getId());
        WalletRewardReportServiceTest.assertNotNull((Object)report);
        WalletRewardReportServiceTest.assertNotNull((Object)report.getPeriod());
        WalletRewardReportServiceTest.assertEquals((long)rewardPeriod.getId(), (long)report.getPeriod().getId());
    }

    @Test
    public void testFindRewardReportPeriods() {
        RewardReport rewardReport = new RewardReport();
        LocalDate date = LocalDate.now();
        WalletAccountService accountService = this.getService(WalletAccountService.class);
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        RewardPeriod period = defaultSettings.getPeriodType().getPeriodOfTime(date, ZoneId.systemDefault());
        rewardReport.setPeriod(period);
        HashSet<WalletReward> rewards = new HashSet<WalletReward>();
        for (int i = 0; i < 20; ++i) {
            Wallet wallet = this.newWallet((long)i + 1L);
            wallet = accountService.saveWallet(wallet, true);
            this.updateWalletBlockchainState(wallet);
            accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
            this.entitiesToClean.add(wallet);
            WalletReward walletReward = new WalletReward();
            walletReward.setWallet(wallet);
            walletReward.setPeriod(period);
            HashSet<WalletPluginReward> pluginRewards = new HashSet<WalletPluginReward>();
            for (int j = 0; j < 10; ++j) {
                WalletPluginReward pluginReward = new WalletPluginReward();
                pluginReward.setAmount(5.0);
                pluginReward.setIdentityId(wallet.getTechnicalId());
                pluginReward.setPluginId("plugin" + j);
                pluginReward.setPoints(5.0);
                pluginReward.setPoolsUsed(false);
                pluginRewards.add(pluginReward);
            }
            walletReward.setRewards(pluginRewards);
            rewards.add(walletReward);
        }
        rewardReport.setRewards(rewards);
        RewardReportService rewardReportService = this.getService(RewardReportService.class);
        rewardReportService.saveRewardReport(rewardReport);
        this.restartTransaction();
        List rewardReportPeriods = rewardReportService.findRewardReportPeriods(0, 1);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReportPeriods);
        WalletRewardReportServiceTest.assertEquals((int)1, (int)rewardReportPeriods.size());
        long from = RewardUtils.timeToSecondsAtDayStart((LocalDate)LocalDate.now(), (ZoneId)ZoneId.systemDefault());
        long to = RewardUtils.timeToSecondsAtDayStart((LocalDate)LocalDate.now().plusMonths(1L), (ZoneId)ZoneId.systemDefault());
        rewardReportPeriods = rewardReportService.findRewardPeriodsBetween(from, to, 0, 10);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReportPeriods);
        WalletRewardReportServiceTest.assertEquals((int)1, (int)rewardReportPeriods.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListRewards() throws Exception {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardTeamService rewardTeamService = this.getService(RewardTeamService.class);
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        WalletRewardReportStorage rewardReportStorage = this.getService(WalletRewardReportStorage.class);
        WalletRewardReportService walletRewardService = new WalletRewardReportService(walletAccountService, (RewardSettingsService)rewardSettingsService, rewardTeamService, rewardReportStorage);
        WalletTokenAdminService tokenAdminService = (WalletTokenAdminService)Mockito.mock(WalletTokenAdminService.class);
        this.resetTokenAdminService(walletTransactionService, tokenAdminService, false, true);
        int contractDecimals = WalletUtils.getContractDetail().getDecimals();
        LocalDate date = YearMonth.of(2019, 5).atEndOfMonth();
        RewardSettings defaultSettings = rewardSettingsService.getSettings();
        rewardSettingsService.registerPlugin(CUSTOM_REWARD_PLUGIN);
        try {
            RewardSettings newSettings = this.cloneSettings(rewardSettingsService.getSettings());
            Set newPluginSettings = newSettings.getPluginSettings();
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            RewardPluginSettings customPluginSetting = newPluginSettings.stream().filter(plugin -> "custom".equals(plugin.getPluginId())).findFirst().orElse(null);
            double sumOfTokensToSend = 5490.0;
            customPluginSetting.setUsePools(true);
            customPluginSetting.setBudgetType(RewardBudgetType.FIXED);
            customPluginSetting.setAmount(sumOfTokensToSend);
            customPluginSetting.setThreshold(0.0);
            customPluginSetting.setEnabled(true);
            rewardSettingsService.saveSettings(newSettings);
            WalletAccountService accountService = this.getService(WalletAccountService.class);
            int enabledWalletsCount = 60;
            for (int i = 0; i < enabledWalletsCount; ++i) {
                Wallet wallet = this.newWallet((long)i + 1L);
                wallet = accountService.saveWallet(wallet, true);
                this.updateWalletBlockchainState(wallet);
                accountService.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
                this.entitiesToClean.add(wallet);
            }
            ArrayList<RewardTeam> teams = new ArrayList<RewardTeam>();
            RewardTeam rewardTeam1 = this.createTeamWithMembers(1, 10, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam1);
            RewardTeam rewardTeam2 = this.createTeamWithMembers(11, 20, RewardBudgetType.FIXED, false);
            teams.add(rewardTeam2);
            RewardTeam rewardTeam3 = this.createTeamWithMembers(21, 30, RewardBudgetType.FIXED_PER_MEMBER, false);
            teams.add(rewardTeam3);
            RewardTeam rewardTeam4 = this.createTeamWithMembers(31, 40, RewardBudgetType.FIXED_PER_MEMBER, false);
            teams.add(rewardTeam4);
            RewardTeam rewardTeam5 = this.createTeamWithMembers(41, 50, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam5);
            RewardTeam rewardTeam6 = this.createTeamWithMembers(51, 60, RewardBudgetType.COMPUTED, false);
            teams.add(rewardTeam6);
            List walletRewards = walletRewardService.listRewards("root3", 10);
            WalletRewardReportServiceTest.assertNotNull((Object)walletRewards);
            WalletRewardReportServiceTest.assertEquals((int)0, (int)walletRewards.size());
            Mockito.when((Object)tokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend + 1L).pow(contractDecimals));
            walletRewardService.sendRewards(date, "root");
            ((WalletTokenAdminService)Mockito.verify((Object)tokenAdminService, (VerificationMode)Mockito.times((int)60))).reward((TransactionDetail)Mockito.any(), (String)Mockito.any());
            walletRewards = walletRewardService.listRewards("root3", 10);
            WalletRewardReportServiceTest.assertNotNull((Object)walletRewards);
            WalletRewardReportServiceTest.assertEquals((int)1, (int)walletRewards.size());
            WalletReward walletReward = (WalletReward)walletRewards.get(0);
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward);
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getPeriod());
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getTransaction());
            WalletRewardReportServiceTest.assertEquals((String)"success", (String)walletReward.getStatus());
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getWallet());
            WalletRewardReportServiceTest.assertEquals((long)3L, (long)walletReward.getIdentityId());
            WalletRewardReportServiceTest.assertEquals((long)3L, (long)walletReward.getWallet().getTechnicalId());
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getTeam());
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getTeams());
            WalletRewardReportServiceTest.assertEquals((int)1, (int)walletReward.getTeams().size());
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getRewards());
            WalletRewardReportServiceTest.assertEquals((int)1, (int)walletReward.getRewards().size());
            WalletPluginReward pluginReward = (WalletPluginReward)walletReward.getRewards().iterator().next();
            WalletRewardReportServiceTest.assertNotNull((Object)pluginReward);
            WalletRewardReportServiceTest.assertEquals((String)"custom", (String)pluginReward.getPluginId());
            WalletRewardReportServiceTest.assertEquals((double)3.0, (double)pluginReward.getPoints(), (double)0.0);
            WalletRewardReportServiceTest.assertEquals((long)3L, (long)pluginReward.getIdentityId());
            WalletRewardReportServiceTest.assertEquals((double)58.0, (double)pluginReward.getAmount(), (double)0.1);
        }
        finally {
            rewardSettingsService.unregisterPlugin("custom");
            rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    private void resetTokenAdminService(final WalletTransactionService walletTransactionService, WalletTokenAdminService tokenAdminService, final boolean pendingTransactions, final boolean successTransactions) throws Exception {
        if (this.container.getComponentInstanceOfType(WalletTokenAdminService.class) != null) {
            this.container.unregisterComponent(WalletTokenAdminService.class);
        }
        this.container.registerComponentInstance(WalletTokenAdminService.class, (Object)tokenAdminService);
        Mockito.reset((Object[])new WalletTokenAdminService[]{tokenAdminService});
        Mockito.when((Object)tokenAdminService.getAdminWalletAddress()).thenReturn((Object)"adminAddress");
        Mockito.when((Object)tokenAdminService.reward((TransactionDetail)Mockito.any(), (String)Mockito.any())).thenAnswer((Answer)new Answer<TransactionDetail>(){

            public TransactionDetail answer(InvocationOnMock invocation) throws Throwable {
                TransactionDetail transactionDetail = (TransactionDetail)invocation.getArgument(0, TransactionDetail.class);
                WalletRewardReportServiceTest.this.saveRewardTransaction(walletTransactionService, pendingTransactions, successTransactions, transactionDetail);
                return transactionDetail;
            }
        });
    }

    private RewardTeam createTeamWithMembers(int startInclusive, int endInclusive, RewardBudgetType budgetType, boolean disabled) {
        WalletRewardTeamService rewardTeamService = this.getService(WalletRewardTeamService.class);
        long[] memberIds = LongStream.rangeClosed(startInclusive, endInclusive).toArray();
        RewardTeam rewardTeam = this.newRewardTeam(memberIds);
        rewardTeam.setName("Name" + startInclusive);
        rewardTeam.setDisabled(disabled);
        rewardTeam.setRewardType(budgetType);
        double totalBudget = (double)LongStream.rangeClosed(startInclusive, endInclusive).sum() * 3.0;
        if (budgetType == RewardBudgetType.COMPUTED || budgetType == RewardBudgetType.FIXED) {
            rewardTeam.setBudget(Double.valueOf(totalBudget));
        } else {
            rewardTeam.setBudget(Double.valueOf(totalBudget / (double)memberIds.length));
        }
        rewardTeam = rewardTeamService.saveTeam(rewardTeam);
        this.entitiesToClean.add(rewardTeam);
        return rewardTeam;
    }

    private double checkComputedRewards(WalletRewardReportService walletRewardService, LocalDate date, int enabledWalletsCount, long amount) {
        double sumOfTokensToSend = 0.0;
        RewardReport rewardReport = walletRewardService.computeRewards(date);
        WalletRewardReportServiceTest.assertNotNull((Object)rewardReport);
        Set rewards = rewardReport.getRewards();
        WalletRewardReportServiceTest.assertNotNull((Object)rewards);
        WalletRewardReportServiceTest.assertEquals((long)enabledWalletsCount, (long)rewardReport.getValidRewardCount());
        for (WalletReward walletReward : rewardReport.getValidRewards()) {
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward);
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getWallet());
            WalletRewardReportServiceTest.assertNotNull((Object)walletReward.getRewards());
            WalletRewardReportServiceTest.assertEquals((int)1, (int)walletReward.getRewards().size());
            WalletRewardReportServiceTest.assertEquals((double)0.0, (double)walletReward.getTokensSent(), (double)0.0);
            long tokensToSend = walletReward.getIdentityId() * amount;
            sumOfTokensToSend += (double)tokensToSend;
            WalletRewardReportServiceTest.assertEquals((String)("Wallet '" + walletReward + "' has an unexpected reward amount"), (double)tokensToSend, (double)walletReward.getTokensToSend(), (double)0.0);
        }
        return sumOfTokensToSend;
    }

    private TransactionDetail createWalltRewardTransaction(WalletTransactionService walletTransactionService, WalletReward walletReward) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setFrom("adminWalletAddress");
        transactionDetail.setTo(walletReward.getWallet().getAddress());
        transactionDetail.setContractAmount(walletReward.getTokensToSend());
        transactionDetail.setValue(walletReward.getTokensToSend());
        this.saveRewardTransaction(walletTransactionService, false, true, transactionDetail);
        return transactionDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRewardTransaction(WalletTransactionService walletTransactionService, boolean pendingTransactions, boolean successTransactions, TransactionDetail transactionDetail) {
        transactionDetail.setHash(this.generateTransactionHash());
        transactionDetail.setPending(pendingTransactions);
        transactionDetail.setSucceeded(successTransactions);
        transactionDetail.setContractMethodName("reward");
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            walletTransactionService.saveTransactionDetail(transactionDetail, false);
        }
        finally {
            RequestLifeCycle.end();
        }
        this.entitiesToClean.add(transactionDetail);
    }
}

