/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service;

import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.settings.InitialFundsSettings;
import org.exoplatform.addon.wallet.model.settings.NetworkSettings;
import org.exoplatform.addon.wallet.model.settings.UserSettings;
import org.exoplatform.addon.wallet.model.settings.WalletSettings;
import org.exoplatform.addon.wallet.model.transaction.FundsRequest;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.service.WalletWebSocketService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class WalletServiceImpl
implements WalletService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(WalletServiceImpl.class);
    private ExoContainer container;
    private WalletContractService contractService;
    private WalletAccountService accountService;
    private SettingService settingService;
    private WebNotificationStorage webNotificationStorage;
    private WalletWebSocketService webSocketService;
    private GlobalSettings configuredGlobalSettings = new GlobalSettings();

    public WalletServiceImpl(WalletContractService contractService, WalletAccountService accountService, WalletWebSocketService webSocketService, WebNotificationStorage webNotificationStorage, PortalContainer container, InitParams params) {
        String value;
        this.container = container;
        this.accountService = accountService;
        this.contractService = contractService;
        this.webSocketService = webSocketService;
        this.webNotificationStorage = webNotificationStorage;
        if (params.containsKey((Object)"networkId")) {
            value = params.getValueParam("networkId").getValue();
            long defaultNetworkId = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setId(defaultNetworkId);
        }
        if (params.containsKey((Object)"networkURL")) {
            String defaultNetworkURL = params.getValueParam("networkURL").getValue();
            this.configuredGlobalSettings.getNetwork().setProviderURL(defaultNetworkURL);
        }
        if (params.containsKey((Object)"networkWSURL")) {
            String defaultNetworkWsURL = params.getValueParam("networkWSURL").getValue();
            this.configuredGlobalSettings.getNetwork().setWebsocketProviderURL(defaultNetworkWsURL);
        }
        if (params.containsKey((Object)"accessPermission")) {
            String defaultAccessPermission = params.getValueParam("accessPermission").getValue();
            this.configuredGlobalSettings.setAccessPermission(defaultAccessPermission);
        }
        if (params.containsKey((Object)"gasLimit")) {
            value = params.getValueParam("gasLimit").getValue();
            long gasLimit = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setGasLimit(Long.valueOf(gasLimit));
        }
        if (params.containsKey((Object)"cheapGasPrice")) {
            value = params.getValueParam("cheapGasPrice").getValue();
            long minGasPrice = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setMinGasPrice(Long.valueOf(minGasPrice));
        }
        if (params.containsKey((Object)"normalGasPrice")) {
            value = params.getValueParam("normalGasPrice").getValue();
            long normalGasPrice = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setNormalGasPrice(Long.valueOf(normalGasPrice));
        }
        if (params.containsKey((Object)"fastGasPrice")) {
            value = params.getValueParam("fastGasPrice").getValue();
            long maxGasPrice = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setMaxGasPrice(Long.valueOf(maxGasPrice));
        }
        if (params.containsKey((Object)"tokenAddress")) {
            String contractAddress = params.getValueParam("tokenAddress").getValue();
            this.configuredGlobalSettings.setContractAddress(contractAddress);
        }
    }

    public void start() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.configuredGlobalSettings.setContractAbi(this.contractService.getContractAbi().toString());
            this.configuredGlobalSettings.setContractBin(this.contractService.getContractBinary());
            this.computeInitialFundsSettings();
            String contractAddress = this.configuredGlobalSettings.getContractAddress();
            if (StringUtils.isBlank((String)contractAddress)) {
                return;
            }
            ContractDetail contractDetail = this.contractService.getContractDetail(contractAddress);
            this.configuredGlobalSettings.setContractDetail(contractDetail);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public void setConfiguredContractDetail(ContractDetail contractDetail) {
        this.configuredGlobalSettings.setContractDetail(contractDetail);
    }

    public void saveInitialFundsSettings(InitialFundsSettings initialFundsSettings) {
        if (initialFundsSettings == null) {
            throw new IllegalArgumentException("initialFundsSettings parameter is mandatory");
        }
        LOG.debug("Saving initial funds settings: {}", new Object[]{initialFundsSettings});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "INITIAL_FUNDS", SettingValue.create((String)WalletUtils.toJsonString((Object)initialFundsSettings)));
        this.configuredGlobalSettings.setInitialFunds(initialFundsSettings);
    }

    public GlobalSettings getSettings() {
        return this.configuredGlobalSettings.clone();
    }

    public UserSettings getUserSettings(String spaceId, String currentUser) {
        GlobalSettings globalSettings = this.getSettings();
        UserSettings userSettings = new UserSettings(globalSettings);
        userSettings.setAdmin(WalletUtils.isUserRewardingAdmin((String)currentUser));
        String accessPermission = globalSettings.getAccessPermission();
        boolean walletEnabled = WalletUtils.isUserMemberOfSpaceOrGroupOrUser((String)currentUser, (String)accessPermission);
        userSettings.setWalletEnabled(walletEnabled);
        if (!walletEnabled) {
            LOG.debug("Wallet is disabled for user {} because he's not member of permission expression {}", new Object[]{currentUser, accessPermission});
            return userSettings;
        }
        Wallet wallet = null;
        if (StringUtils.isNotBlank((String)spaceId)) {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.SPACE.getId(), spaceId, currentUser);
            if (wallet != null && !WalletUtils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
                LOG.warn("User {} is not allowed to display space wallet {}", new Object[]{currentUser, spaceId});
                userSettings.setWalletEnabled(false);
            }
        } else {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser, currentUser);
        }
        if (wallet != null) {
            userSettings.setWalletEnabled(userSettings.isWalletEnabled() && wallet.isEnabled());
        }
        if (userSettings.isWalletEnabled() || userSettings.isAdmin()) {
            userSettings.setCometdToken(this.webSocketService.getUserToken(currentUser));
            userSettings.setCometdContext(this.webSocketService.getCometdContextName());
            SettingValue userSettingsValue = this.getSettingService().get(Context.USER.id(currentUser), WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS");
            WalletSettings walletSettings = null;
            walletSettings = userSettingsValue != null && userSettingsValue.getValue() != null ? (WalletSettings)WalletUtils.fromJsonString((String)userSettingsValue.getValue().toString(), WalletSettings.class) : new WalletSettings();
            userSettings.setUserPreferences(walletSettings);
            if (wallet != null) {
                walletSettings.setWalletAddress(wallet.getAddress());
                if (this.accountService.isWalletOwner(wallet, currentUser)) {
                    walletSettings.setPhrase(wallet.getPassPhrase());
                    walletSettings.setHasKeyOnServerSide(wallet.isHasPrivateKey());
                } else {
                    WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                }
                this.accountService.retrieveWalletBlockchainState(wallet);
                userSettings.setWallet(wallet);
            }
            walletSettings.setAddresesLabels(this.accountService.getAddressesLabelsVisibleBy(currentUser));
        }
        return userSettings;
    }

    public void saveUserPreferences(String currentUser, WalletSettings userPreferences) {
        if (userPreferences == null) {
            throw new IllegalArgumentException("userPreferences parameter is mandatory");
        }
        this.getSettingService().set(Context.USER.id(currentUser), WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS", SettingValue.create((String)WalletUtils.toJsonString((Object)userPreferences)));
    }

    public void requestFunds(FundsRequest fundsRequest, String currentUser) throws IllegalAccessException {
        Wallet requestSender = this.accountService.getWalletByAddress(fundsRequest.getAddress());
        if (StringUtils.isNotBlank((String)currentUser)) {
            if (requestSender == null) {
                throw new IllegalStateException("Bad request sent to server with unknown sender address");
            }
            String requestSenderId = requestSender.getId();
            String requestSenderType = requestSender.getType();
            if (WalletType.isUser((String)requestSenderType) && !StringUtils.equals((String)currentUser, (String)requestSenderId)) {
                LOG.warn("Bad request sent to server with invalid sender type or id {} / {}", new Object[]{requestSenderType, requestSenderId});
                throw new IllegalAccessException("Bad request sent to server with invalid sender");
            }
            if (WalletType.isSpace((String)requestSenderType) && !WalletUtils.isUserSpaceMember((String)requestSenderId, (String)fundsRequest.getReceipient())) {
                throw new IllegalAccessException("Request sender is not allowed to request funds from space");
            }
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        GlobalSettings settings = this.getSettings();
        if (!StringUtils.isBlank((String)fundsRequest.getContract())) {
            ContractDetail contractDetail = settings.getContractDetail();
            if (contractDetail == null || !StringUtils.equalsIgnoreCase((String)contractDetail.getAddress(), (String)fundsRequest.getContract())) {
                throw new IllegalStateException("Bad request sent to server with invalid contract address (Only default addresses are permitted)");
            }
            ctx.append(WalletUtils.CONTRACT_DETAILS_PARAMETER, (Object)contractDetail);
        }
        String requestReceipientId = fundsRequest.getReceipient();
        String requestReceipientType = fundsRequest.getReceipientType();
        Wallet requestReceipient = this.accountService.getWalletByTypeAndId(WalletType.getType((String)requestReceipientType).getId(), requestReceipientId);
        if (requestReceipient == null || requestReceipient.getTechnicalId() == 0L) {
            LOG.warn("Can't find fund request recipient with id {} and type {}", new Object[]{requestReceipientId, requestReceipientType});
        }
        ctx.append(WalletUtils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER, (Object)this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser));
        ctx.append(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)requestSender);
        ctx.append(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)requestReceipient);
        ctx.append(WalletUtils.FUNDS_REQUEST_PARAMETER, (Object)fundsRequest);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"FundsRequestNotificationPlugin"))).execute(ctx);
    }

    public void markFundRequestAsSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        notificationInfo.getOwnerParameter().put("sent", "true");
        this.webNotificationStorage.update(notificationInfo, false);
    }

    public boolean isFundRequestSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        String fundRequestSentString = (String)notificationInfo.getOwnerParameter().get("sent");
        return Boolean.parseBoolean(fundRequestSentString);
    }

    private void computeInitialFundsSettings() {
        SettingValue initialFundsSettingsValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "INITIAL_FUNDS");
        InitialFundsSettings initialFundsSettings = null;
        initialFundsSettings = initialFundsSettingsValue != null && initialFundsSettingsValue.getValue() != null ? (InitialFundsSettings)WalletUtils.fromJsonString((String)initialFundsSettingsValue.getValue().toString(), InitialFundsSettings.class) : new InitialFundsSettings();
        this.computeInitialEtherFund(initialFundsSettings);
        this.configuredGlobalSettings.setInitialFunds(initialFundsSettings);
    }

    private void computeInitialEtherFund(InitialFundsSettings initialFundsSettings) {
        NetworkSettings network = this.configuredGlobalSettings.getNetwork();
        long gasLimit = 150000L;
        long gasPrice = 15000000000L;
        if (network != null) {
            if (network.getGasLimit() != null && network.getGasLimit() > 0L) {
                gasLimit = network.getGasLimit();
            }
            if (network.getMaxGasPrice() != null && network.getMaxGasPrice() > 0L) {
                gasPrice = network.getMaxGasPrice();
            }
        }
        BigInteger etherAmountInWEI = new BigInteger(String.valueOf(gasLimit)).multiply(new BigInteger(String.valueOf(gasPrice)));
        double etherInitialFund = WalletUtils.convertFromDecimals((BigInteger)etherAmountInWEI, (int)18);
        double etherAmountMaxDecimals = 3.0;
        double etherAmountDecimals = Math.pow(10.0, etherAmountMaxDecimals);
        initialFundsSettings.setEtherAmount(Math.ceil(etherInitialFund * etherAmountDecimals) / etherAmountDecimals);
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }
}

