/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.model.ApplicationType;

public class ApplicationRegistrySetupService
implements StartableClusterAware {
    private static final String SPACE_WALLET_APP_ID = "wallet/SpaceWallet";
    private static final String SPACE_WALLET_PORTLET_NAME = "SpaceWallet";
    private static final List<String> EVERYONE_PERMISSION_LIST = Collections.singletonList("Everyone");
    private static final String OLD_WALLET_CATEGORY_NAME = "EthereumWallet";
    private static final String WALLET_CATEGORY_NAME = "Wallet";
    private ExoContainer container;
    private ApplicationRegistryService applicationRegistryService;
    private boolean isDone;

    public ApplicationRegistrySetupService(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ApplicationCategory walletCategory;
            ApplicationCategory oldCategory = this.getApplicationRegistryService().getApplicationCategory(OLD_WALLET_CATEGORY_NAME);
            if (oldCategory != null) {
                this.getApplicationRegistryService().remove(oldCategory);
            }
            if ((walletCategory = this.getApplicationRegistryService().getApplicationCategory(WALLET_CATEGORY_NAME)) == null) {
                walletCategory = new ApplicationCategory();
                walletCategory.setAccessPermissions(EVERYONE_PERMISSION_LIST);
                walletCategory.setName(WALLET_CATEGORY_NAME);
                walletCategory.setDescription("Wallet applications");
                walletCategory.setDisplayName(WALLET_CATEGORY_NAME);
                Application application = new Application();
                walletCategory.setApplications(Collections.singletonList(application));
                application.setAccessPermissions(new ArrayList<String>(EVERYONE_PERMISSION_LIST));
                application.setDisplayName("Space Wallet");
                application.setDescription("Space Wallet");
                application.setApplicationName(SPACE_WALLET_PORTLET_NAME);
                application.setCategoryName(WALLET_CATEGORY_NAME);
                application.setContentId(SPACE_WALLET_APP_ID);
                application.setType(ApplicationType.PORTLET);
                this.getApplicationRegistryService().save(walletCategory);
                this.getApplicationRegistryService().save(walletCategory, application);
            }
            this.isDone = true;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public boolean isDone() {
        return this.isDone;
    }

    public ApplicationRegistryService getApplicationRegistryService() {
        if (this.applicationRegistryService == null) {
            this.applicationRegistryService = (ApplicationRegistryService)CommonsUtils.getService(ApplicationRegistryService.class);
        }
        return this.applicationRegistryService;
    }
}

