/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.listener;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.blockchain.listener.TransactionMinedListener;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionMinedListenerTest
extends BaseWalletTest {
    @Mock
    private WalletAccountService accountService;
    @Mock
    private WalletTransactionService walletTransactionService;
    @Mock
    private ListenerService listenerService;
    private TransactionMinedListener listener;
    private Event<Object, Map<String, Object>> event;
    private TransactionDetail transactionDetail;
    private String hash = "transactionHash";
    private String fromAddress = "fromAddress";
    private String toAddress = "toAddress";
    private String byAddress = "byAddress";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new TransactionMinedListener(this.accountService, this.walletTransactionService, this.listenerService);
        this.event = new Event("exo.wallet.transaction.mined", null, Collections.singletonMap("hash", this.hash));
        this.transactionDetail = new TransactionDetail();
        this.transactionDetail.setHash(this.hash);
        this.transactionDetail.setFrom(this.fromAddress);
        this.transactionDetail.setTo(this.toAddress);
    }

    @Test
    public void testOnEventWhenTransactionIsNull() throws Exception {
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.times((int)1))).getTransactionByHash(this.hash);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.accountService, this.listenerService});
    }

    @Test
    public void testOnEventWhenTransactionIsSucceeded() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setSucceeded(true);
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.accountService});
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedAndUpdated", null, (Object)this.transactionDetail);
    }

    @Test
    public void testOnEventWhenTransactionIsNotForContract() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.accountService});
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedAndUpdated", null, (Object)this.transactionDetail);
    }

    @Test
    public void testOnEventWhenTransactionIsForContractTransfer() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setContractMethodName("transfer");
        this.transactionDetail.setFromWallet(new Wallet());
        this.transactionDetail.getFromWallet().setAddress(this.fromAddress);
        this.transactionDetail.setToWallet(new Wallet());
        this.transactionDetail.getToWallet().setAddress(this.toAddress);
        this.listener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedAndUpdated", null, (Object)this.transactionDetail);
        HashMap<String, Set<String>> walletModifications = new HashMap<String, Set<String>>();
        walletModifications.put(this.fromAddress, new HashSet<String>(Arrays.asList("ether_transfer", "transfer")));
        walletModifications.put(this.toAddress, Collections.singleton("transfer"));
        ((WalletAccountService)Mockito.verify((Object)this.accountService, (VerificationMode)Mockito.times((int)1))).refreshWalletsFromBlockchain(walletModifications);
    }

    @Test
    public void testOnEventWhenTransactionIsForContractTransferFrom() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setContractMethodName("transferFrom");
        this.transactionDetail.setFromWallet(new Wallet());
        this.transactionDetail.getFromWallet().setAddress(this.fromAddress);
        this.transactionDetail.setToWallet(new Wallet());
        this.transactionDetail.getToWallet().setAddress(this.toAddress);
        this.transactionDetail.setByWallet(new Wallet());
        this.transactionDetail.getByWallet().setAddress(this.byAddress);
        this.listener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedAndUpdated", null, (Object)this.transactionDetail);
        HashMap<String, Set<String>> walletModifications = new HashMap<String, Set<String>>();
        walletModifications.put(this.fromAddress, new HashSet<String>(Arrays.asList("ether_transfer", "transferFrom")));
        walletModifications.put(this.toAddress, Collections.singleton("transferFrom"));
        walletModifications.put(this.byAddress, Collections.singleton("transferFrom"));
        ((WalletAccountService)Mockito.verify((Object)this.accountService, (VerificationMode)Mockito.times((int)1))).refreshWalletsFromBlockchain(walletModifications);
    }

    @Test
    public void testOnEventWhenTransactionIsForContractApprove() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setContractMethodName("approve");
        this.transactionDetail.setFromWallet(new Wallet());
        this.transactionDetail.getFromWallet().setAddress(this.fromAddress);
        this.transactionDetail.setToWallet(new Wallet());
        this.transactionDetail.getToWallet().setAddress(this.toAddress);
        this.listener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedAndUpdated", null, (Object)this.transactionDetail);
        HashMap<String, HashSet<String>> walletModifications = new HashMap<String, HashSet<String>>();
        walletModifications.put(this.fromAddress, new HashSet<String>(Arrays.asList("ether_transfer")));
        ((WalletAccountService)Mockito.verify((Object)this.accountService, (VerificationMode)Mockito.times((int)1))).refreshWalletsFromBlockchain(walletModifications);
    }
}

