/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.listener.BlockchainTransactionProcessorListener;
import org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService;
import org.exoplatform.addon.wallet.job.ContractTransactionVerifierJob;
import org.exoplatform.addon.wallet.job.PendingTransactionVerifierJob;
import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.CronJob;
import org.exoplatform.services.scheduler.JobSchedulerService;

public class ServiceLoaderServlet
extends HttpServlet
implements ExoBlockchainTransactionService {
    private static final long serialVersionUID = 4629318431709644350L;
    private static final Log LOG = ExoLogger.getLogger(ServiceLoaderServlet.class);
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public void init() throws ServletException {
        executor.scheduleAtFixedRate(() -> this.instantiateBlockchainServices(), 10L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExoBlockchainTransaction
    private void instantiateBlockchainServices() {
        PortalContainer container = PortalContainer.getInstance();
        if (container == null || !container.isStarted()) {
            LOG.debug((Object)"Portal Container is not yet started");
            return;
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            ClassLoader webappClassLoader = this.getWebappClassLoader();
            Class<?> class1 = webappClassLoader.loadClass(BouncyCastleProvider.class.getName());
            Provider provider = (Provider)class1.newInstance();
            Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
            Security.addProvider(provider);
            provider = Security.getProvider(BouncyCastleProvider.PROVIDER_NAME);
            LOG.info("BouncyCastleProvider class registered with version {}", new Object[]{provider.getVersion()});
            EthereumClientConnector web3jConnector = new EthereumClientConnector(webappClassLoader);
            container.registerComponentInstance(EthereumClientConnector.class, (Object)web3jConnector);
            web3jConnector.start();
            EthereumBlockchainTransactionService transactionDecoderService = new EthereumBlockchainTransactionService(web3jConnector, webappClassLoader);
            container.registerComponentInstance(BlockchainTransactionService.class, (Object)transactionDecoderService);
            EthereumWalletTokenAdminService tokenAdminService = new EthereumWalletTokenAdminService(web3jConnector, webappClassLoader);
            container.registerComponentInstance(WalletTokenAdminService.class, (Object)tokenAdminService);
            tokenAdminService.start();
            ListenerService listernerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listernerService.addListener("exo.addon.wallet.transaction.loaded", (Listener)new BlockchainTransactionProcessorListener(container));
            this.addBlockchainScheduledJob(PendingTransactionVerifierJob.class, "Configuration for wallet transaction stored status verifier", "0/10 * * * * ?");
            this.addBlockchainScheduledJob(ContractTransactionVerifierJob.class, "Add a job to verify if mined contract transactions are added in database", "0 0 * ? * * *");
            LOG.debug((Object)"Blockchain Service instances created");
        }
        catch (Throwable e) {
            LOG.error((Object)"Error registering service into portal container", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        executor.shutdown();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.init();
        super.service(req, resp);
    }

    private void addBlockchainScheduledJob(Class<?> jobClass, String description, String defaultCronExpression) throws Exception {
        JobSchedulerService schedulerService = (JobSchedulerService)CommonsUtils.getService(JobSchedulerService.class);
        String jobSimpleName = jobClass.getSimpleName();
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("cronjob.info");
        propertiesParam.setDescription(description);
        propertiesParam.setProperty("jobName", jobSimpleName);
        propertiesParam.setProperty("groupName", "Wallet");
        propertiesParam.setProperty("job", jobClass.getName());
        propertiesParam.setProperty("expression", System.getProperty("exo.wallet." + jobSimpleName + ".expression", defaultCronExpression));
        params.addParam((Object)propertiesParam);
        CronJob cronJob = new CronJob(params);
        schedulerService.addCronJob((ComponentPlugin)cronJob);
    }

    public ClassLoader getWebappClassLoader() {
        return this.getServletContext().getClassLoader();
    }
}

