/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.blockchain.listener.BlockMinedListener;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.web3j.protocol.core.methods.response.EthBlock;

/*
 * Exception performing whole class analysis ignored.
 */
@Asynchronous
public class BlockMinedListener
extends Listener<EthBlock.Block, Boolean>
implements ExoWalletStatisticService {
    private static final Log LOG;
    private ExoContainer container;
    private WalletTransactionService transactionService;
    private BlockchainTransactionService blockchainTransactionService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public BlockMinedListener(ExoContainer container, WalletTransactionService transactionService, BlockchainTransactionService blockchainTransactionService) {
        this.container = container;
        this.transactionService = transactionService;
        this.blockchainTransactionService = blockchainTransactionService;
    }

    @ExoWalletStatistic(local=false, service="wallet", operation="eth_getBlockByXXX")
    public void onEvent(Event<EthBlock.Block, Boolean> event) throws Exception {
        Event<EthBlock.Block, Boolean> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        ExoWalletStatisticAspect.aspectOf().around(new AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Event event = (Event)methodArgs[0];
        EthBlock.Block block = (EthBlock.Block)event.getSource();
        boolean newBlock = (Boolean)event.getData();
        if (newBlock) {
            parameters.put("operation", "eth_getBlockByHash");
        } else {
            parameters.put("operation", "eth_getBlockByNumber");
        }
        parameters.put("blockchain_network_id", WalletUtils.getNetworkId());
        parameters.put("blockchain_network_url_suffix", WalletUtils.getBlockchainURLSuffix());
        parameters.put("block_hash", block.getHash());
        parameters.put("block_number", block.getNumber().longValue());
        return parameters;
    }

    static {
        BlockMinedListener.ajc$preClinit();
        LOG = ExoLogger.getLogger(BlockMinedListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void onEvent_aroundBody0(BlockMinedListener ajc$this, Event event, JoinPoint joinPoint) {
        EthBlock.Block block = (EthBlock.Block)event.getSource();
        long blockNumber = block.getNumber().longValue();
        ExoContainerContext.setCurrentContainer((ExoContainer)ajc$this.container);
        RequestLifeCycle.begin((ExoContainer)ajc$this.container);
        try {
            List pendingTransactions = ajc$this.transactionService.getPendingTransactions();
            if (pendingTransactions.isEmpty()) {
                LOG.debug("No pending transaction to check for block '{}'", new Object[]{blockNumber});
            } else {
                LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database in block {}", new Object[]{pendingTransactions.size(), blockNumber});
                List transactions = block.getTransactions();
                Set minedTransactionHashes = transactions.stream().map(tx -> tx.get().toString().toLowerCase()).collect(Collectors.toSet());
                Set pendingTransactionHashes = pendingTransactions.stream().map(TransactionDetail::getHash).collect(Collectors.toSet());
                minedTransactionHashes.retainAll(pendingTransactionHashes);
                if (!minedTransactionHashes.isEmpty()) {
                    for (String hash : minedTransactionHashes) {
                        try {
                            ajc$this.blockchainTransactionService.checkTransactionStatusOnBlockchain(hash, true);
                        }
                        catch (Exception e) {
                            LOG.warn("Error checking mined transaction on blockchain: {}", new Object[]{hash, e});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while checking pending transactions on mined block '{}'", new Object[]{blockNumber, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BlockMinedListener.java", BlockMinedListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "org.exoplatform.wallet.blockchain.listener.BlockMinedListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 45);
    }
}

