/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.support;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CallLog {
    private static final Log LOG = ExoLogger.getLogger(CallLog.class);
    public static final String TRACE_LEVEL = "trace".intern();
    public static final String DEBUG_LEVEL = "debug".intern();
    public static final String INFO_LEVEL = "info".intern();
    public static final String WARN_LEVEL = "warn".intern();
    public static final String ERROR_LEVEL = "error".intern();
    public static final String MESSAGE_NO_DATA = "<no data>";
    public static final int MESSAGE_MAX_LENGTH = 4096;
    public static final int MESSAGE_CRITICAL_LENGTH = 10240;
    protected static final int MESSAGE_CRITICAL_LENGTH_FINAL = 10496;

    public static boolean isSafe(String msg) {
        return msg == null || msg.length() <= 4096;
    }

    public static String validate(String msg) {
        if (msg == null || msg.length() == 0) {
            return MESSAGE_NO_DATA;
        }
        if (CallLog.isSafe(msg)) {
            if (msg != null && msg.length() > 10240) {
                LOG.warn((Object)("Cut loo long message: '" + msg.substring(0, 64) + "...'. It's recommended to use log messages not longer of " + 4096 + " chars. All messages longer of " + 10240 + " will be cut."));
                return msg.substring(0, 10240) + "...";
            }
        } else {
            LOG.warn((Object)("Message: '" + msg.substring(0, 64) + "...' exceeds recommeded length of " + 4096 + " chars. Avoid using longer messages due to possible performance impact."));
        }
        return msg;
    }

    CallLog() {
    }

    protected String validateFinal(String msg) {
        if (msg != null && msg.length() > 10496) {
            return msg.substring(0, 10496) + "...";
        }
        return msg;
    }

    public void info(String msg) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)this.validateFinal(msg));
        }
    }

    public void warn(String msg) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)this.validateFinal(msg));
        }
    }

    public void error(String msg) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)this.validateFinal(msg));
        }
    }

    public void debug(String msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.validateFinal(msg));
        }
    }

    public void trace(String msg) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)CallLog.validate(msg));
        }
    }
}

