/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.support;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CallLog {
    private static final Log LOG = ExoLogger.getLogger(CallLog.class);
    public static final String TRACE_LEVEL = "trace".intern();
    public static final String DEBUG_LEVEL = "debug".intern();
    public static final String INFO_LEVEL = "info".intern();
    public static final String WARN_LEVEL = "warn".intern();
    public static final String ERROR_LEVEL = "error".intern();
    public static final String MESSAGE_NO_DATA = "<no data>";
    public static final int MESSAGE_MAX_LENGTH = 5120;
    public static final int MESSAGE_CRITICAL_LENGTH = 10240;
    protected static final int MESSAGE_CRITICAL_LENGTH_FINAL = 10496;
    public static final int MESSAGES_BUFFER_MAX_SIZE = 50;
    public static final int MESSAGES_BUFFER_EXPIRATION_MILLIS = 60000;
    public static final int MESSAGES_BUFFER_WAIT_MILLIS = 20000;
    private final Queue<Message> messages = new ConcurrentLinkedQueue<Message>();
    private Map<Boolean, Thread> flusher = new ConcurrentHashMap<Boolean, Thread>(1);

    public static boolean isSafe(String msg) {
        return msg == null || msg.length() <= 5120;
    }

    public static String validate(String msg) {
        if (msg == null || msg.length() == 0) {
            return MESSAGE_NO_DATA;
        }
        if (CallLog.isSafe(msg)) {
            if (msg != null && msg.length() > 10240) {
                LOG.warn((Object)("Cut loo long message: '" + msg.substring(0, 64) + "...'. It's recommended to use log messages not longer of " + 5120 + " chars. All messages longer of " + 10240 + " will be cut."));
                return msg.substring(0, 10240) + "...";
            }
        } else {
            LOG.warn((Object)("Message: '" + msg.substring(0, 64) + "...' exceeds recommeded length of " + 5120 + " chars. Avoid using longer messages due to possible performance impact."));
        }
        return msg;
    }

    CallLog() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    CallLog.this.flushAll();
                }
            });
        }
        catch (Throwable e) {
            LOG.warn((Object)("Failed to register shutdown hook " + e.getMessage()));
        }
    }

    public void info(final String msg) {
        if (LOG.isInfoEnabled()) {
            this.messages.add(new Message(){

                @Override
                void log() {
                    LOG.info((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void info(final String msg, LocalDateTime timestamp) {
        if (LOG.isInfoEnabled()) {
            this.messages.add(new Message(timestamp){

                @Override
                void log() {
                    LOG.info((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void warn(final String msg) {
        if (LOG.isWarnEnabled()) {
            this.messages.add(new Message(){

                @Override
                void log() {
                    LOG.warn((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void warn(final String msg, LocalDateTime timestamp) {
        if (LOG.isWarnEnabled()) {
            this.messages.add(new Message(timestamp){

                @Override
                void log() {
                    LOG.warn((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void error(final String msg) {
        if (LOG.isErrorEnabled()) {
            this.messages.add(new Message(){

                @Override
                void log() {
                    LOG.error((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void error(final String msg, LocalDateTime timestamp) {
        if (LOG.isErrorEnabled()) {
            this.messages.add(new Message(timestamp){

                @Override
                void log() {
                    LOG.error((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void debug(final String msg) {
        if (LOG.isDebugEnabled()) {
            this.messages.add(new Message(){

                @Override
                void log() {
                    LOG.debug((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void debug(final String msg, LocalDateTime timestamp) {
        if (LOG.isDebugEnabled()) {
            this.messages.add(new Message(timestamp){

                @Override
                void log() {
                    LOG.debug((Object)CallLog.this.validateFinal(msg));
                }
            });
            this.flush();
        }
    }

    public void trace(final String msg) {
        if (LOG.isTraceEnabled()) {
            this.messages.add(new Message(){

                @Override
                void log() {
                    LOG.trace((Object)CallLog.validate(msg));
                }
            });
            this.flush();
        }
    }

    public void trace(final String msg, LocalDateTime timestamp) {
        if (LOG.isTraceEnabled()) {
            this.messages.add(new Message(timestamp){

                @Override
                void log() {
                    LOG.trace((Object)CallLog.validate(msg));
                }
            });
            this.flush();
        }
    }

    protected String validateFinal(String msg) {
        if (msg != null && msg.length() > 10496) {
            return msg.substring(0, 10496) + "...";
        }
        return msg;
    }

    private void flushAll() {
        int buffLen = this.messages.size();
        if (buffLen > 0) {
            Message m2;
            ArrayList<Message> buff = new ArrayList<Message>(buffLen);
            while ((m2 = this.messages.poll()) != null) {
                buff.add(m2);
                if (--buffLen > 0) continue;
            }
            buff.stream().sorted().forEach(m -> m.log());
        }
    }

    private boolean waitForMessages() {
        if (this.messages.size() > 50) {
            return false;
        }
        Message m = this.messages.peek();
        return m == null || !m.getTimestamp().isBefore(LocalDateTime.now(ZoneOffset.UTC).minus(60000L, ChronoUnit.MILLIS));
    }

    private Thread newFlushThread() {
        Thread t = new Thread(CallLog.class.getName() + "-flusher"){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)("Error sleeping in flusher thread: " + e.getMessage()));
                    }
                } while (CallLog.this.waitForMessages());
                try {
                    CallLog.this.flusher.remove(Boolean.TRUE, this);
                    CallLog.this.flushAll();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Error flushing messages to log", e);
                }
            }
        };
        t.setDaemon(false);
        t.start();
        return t;
    }

    private void flush() {
        this.flusher.compute(Boolean.TRUE, (k, t) -> {
            if (t == null || !t.isAlive()) {
                return this.newFlushThread();
            }
            return t;
        });
    }

    abstract class Message
    implements Comparable<Message> {
        private final LocalDateTime timestamp;

        Message() {
            this.timestamp = LocalDateTime.now();
        }

        Message(LocalDateTime timestamp) {
            if (timestamp == null) {
                timestamp = LocalDateTime.now();
            }
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(Message o) {
            return this.getTimestamp().compareTo(o.getTimestamp());
        }

        LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        abstract void log();
    }
}

