/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.CallArgumentException;
import org.exoplatform.webconferencing.CallConflictException;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.CallInfoException;
import org.exoplatform.webconferencing.CallNotFoundException;
import org.exoplatform.webconferencing.CallOwnerException;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.CallProviderConfiguration;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.CallSettingsException;
import org.exoplatform.webconferencing.CallState;
import org.exoplatform.webconferencing.GroupInfo;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.IdentityStateException;
import org.exoplatform.webconferencing.InvalidCallException;
import org.exoplatform.webconferencing.ParticipantInfo;
import org.exoplatform.webconferencing.ParticipantNotFoundException;
import org.exoplatform.webconferencing.UserCallListener;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure1;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure11;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure3;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure5;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure7;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure9;
import org.exoplatform.webconferencing.dao.CallDAO;
import org.exoplatform.webconferencing.dao.ParticipantDAO;
import org.exoplatform.webconferencing.dao.StorageException;
import org.exoplatform.webconferencing.domain.CallEntity;
import org.exoplatform.webconferencing.domain.ParticipantEntity;
import org.exoplatform.webconferencing.domain.ParticipantId;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class WebConferencingService
implements Startable {
    public static final int ID_MAX_LENGTH = 255;
    public static final int TEXT_MAX_LENGTH = 255;
    public static final int ARG_MAX_LENGTH = 32;
    public static final int DATA_MAX_LENGTH = 2000;
    public static final String SPACE_TYPE_NAME;
    public static final String CHAT_ROOM_TYPE_NAME;
    protected static final String GROUP_CALL_TYPE;
    protected static final String CALL_OWNER_SCOPE_NAME;
    protected static final String CALL_ID_SCOPE_NAME;
    protected static final String USER_CALLS_SCOPE_NAME;
    protected static final String PROVIDER_SCOPE_NAME;
    public static final String OWNER_TYPE_SPACE = "space";
    public static final String OWNER_TYPE_CHATROOM = "chat_room";
    protected static final Log LOG;
    protected final OrganizationService organization;
    protected final IdentityManager socialIdentityManager;
    protected final ListenerService listenerService;
    protected final SettingService settingService;
    protected final CallDAO callStorage;
    protected final ParticipantDAO participantsStorage;
    protected final Map<String, CallProvider> providers = new ConcurrentHashMap<String, CallProvider>();
    protected SpaceService spaceService;
    protected final Map<String, Set<UserCallListener>> userListeners = new ConcurrentHashMap<String, Set<UserCallListener>>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public static boolean isValidId(String id) {
        return id != null && id.length() > 0 && id.length() <= 255;
    }

    public static boolean isValidText(String text) {
        return text == null || text.length() > 0 && text.length() <= 255;
    }

    public static boolean isValidArg(String arg) {
        return arg == null || arg.length() > 0 && arg.length() <= 32;
    }

    public static boolean isNotNullArg(String arg) {
        return arg != null && arg.length() > 0 && arg.length() <= 32;
    }

    public static boolean isValidData(String data) throws UnsupportedEncodingException {
        return data == null || data.length() > 0 && data.getBytes("UTF8").length <= 2000;
    }

    public WebConferencingService(OrganizationService organization, IdentityManager socialIdentityManager, ListenerService listenerService, SettingService settingService, CallDAO callStorage, ParticipantDAO participantsStorage) {
        this.organization = organization;
        this.socialIdentityManager = socialIdentityManager;
        this.listenerService = listenerService;
        this.settingService = settingService;
        this.callStorage = callStorage;
        this.participantsStorage = participantsStorage;
    }

    public UserInfo getUserInfo(String id) throws IdentityStateException {
        User user;
        try {
            user = this.organization.getUserHandler().findUserByName(id, UserStatus.ANY);
        }
        catch (Exception e) {
            throw new IdentityStateException("Error finding user in organization service", e);
        }
        if (user != null) {
            if (user.isEnabled()) {
                Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", id, true);
                if (userIdentity != null) {
                    Profile socialProfile = userIdentity.getProfile();
                    List ims = (List)socialProfile.getProperty("ims");
                    UserInfo info = new UserInfo(user.getUserName(), user.getFirstName(), user.getLastName());
                    if (ims != null) {
                        for (Map m : ims) {
                            CallProvider provider;
                            String imType = (String)m.get("key");
                            String imId = (String)m.get("value");
                            if (imId == null || imId.length() <= 0 || (provider = this.getProvider(imType)) == null || !provider.isActive() || !provider.isSupportedType(imType)) continue;
                            try {
                                UserInfo.IMInfo im = provider.getIMInfo(imId);
                                if (im == null) continue;
                                info.addImAccount(im);
                            }
                            catch (CallProviderException e) {
                                LOG.warn((Object)e.getMessage());
                            }
                        }
                    }
                    info.setAvatarLink(socialProfile.getAvatarUrl());
                    info.setProfileLink(LinkProvider.getUserProfileUri((String)id));
                    return info;
                }
                LOG.warn((Object)("Social identity not found for " + user.getUserName() + " (" + user.getFirstName() + " " + user.getLastName() + ")"));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignore disabled user (treat as not found): " + id));
            }
        } else {
            LOG.warn((Object)("User not found: " + id));
        }
        return null;
    }

    public SpaceInfo getSpaceInfo(String spacePrettyName) throws IdentityStateException, StorageException {
        return this.spaceInfo(spacePrettyName, this.findGroupCallId(spacePrettyName));
    }

    protected SpaceInfo spaceInfo(String spacePrettyName, String callId) throws IdentityStateException {
        Space socialSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        SpaceInfo space = new SpaceInfo(socialSpace);
        for (String sm : socialSpace.getMembers()) {
            UserInfo user = this.getUserInfo(sm);
            if (user != null) {
                space.addMember(user);
                continue;
            }
            LOG.warn((Object)("Skipped not found space member " + sm + " of " + spacePrettyName));
        }
        space.setProfileLink(socialSpace.getUrl());
        space.setAvatarLink(socialSpace.getAvatarUrl());
        space.setCallId(callId);
        return space;
    }

    public RoomInfo getRoomInfo(String id, String title, String[] members) throws IdentityStateException, StorageException {
        return this.roomInfo(id, title, members, this.findGroupCallId(id));
    }

    protected RoomInfo roomInfo(String id, String title, String[] members, String callId) throws IdentityStateException {
        RoomInfo room = new RoomInfo(id, title);
        for (String userName : members) {
            UserInfo user = this.getUserInfo(userName);
            if (user != null) {
                room.addMember(user);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("External room member " + userName + " for '" + title + "'"));
            }
            room.addMember(new ParticipantInfo(userName));
        }
        room.setProfileLink(IdentityInfo.EMPTY);
        room.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
        room.setCallId(callId);
        return room;
    }

    public CallInfo addCall(String id, String ownerId, String ownerType, String title, String providerType, Collection<String> parts) throws CallArgumentException, StorageException, IdentityStateException, CallConflictException, CallSettingsException {
        if (WebConferencingService.isValidId(id)) {
            if (WebConferencingService.isValidId(ownerId)) {
                if (WebConferencingService.isNotNullArg(ownerType)) {
                    if (WebConferencingService.isNotNullArg(providerType)) {
                        if (WebConferencingService.isValidText(title)) {
                            Object avatar;
                            IdentityInfo owner;
                            String prevId;
                            boolean isGroup;
                            String currentUserId = this.currentUserId();
                            boolean isUser = UserInfo.TYPE_NAME.equals(ownerType);
                            boolean isSpace = OWNER_TYPE_SPACE.equals(ownerType);
                            boolean isRoom = OWNER_TYPE_CHATROOM.equals(ownerType);
                            boolean bl = isGroup = isSpace || isRoom;
                            if (isGroup && (prevId = this.findGroupCallId(ownerId)) != null && !prevId.equals(id)) {
                                this.deleteCall(prevId);
                                LOG.warn((Object)("Deleted outdated group call: " + prevId));
                            }
                            this.invalidateCall(id, isGroup);
                            if (isUser) {
                                UserInfo userInfo = this.getUserInfo(ownerId);
                                if (userInfo == null) {
                                    owner = new RoomInfo(ownerId, title);
                                    owner.setAvatarLink("/eXoSkin/skin/images/avatar/DefaultUserAvatar.png");
                                } else {
                                    owner = userInfo;
                                    owner.setProfileLink(userInfo.getProfileLink());
                                    avatar = userInfo.getAvatarLink();
                                    avatar = avatar != null ? avatar : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
                                    owner.setAvatarLink((String)avatar);
                                }
                            } else if (isSpace) {
                                Space space = this.spaceService.getSpaceByPrettyName(ownerId);
                                if (space != null) {
                                    owner = new SpaceInfo(space);
                                    owner.setProfileLink(space.getUrl());
                                    avatar = space.getAvatarUrl();
                                    avatar = avatar != null ? avatar : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
                                    owner.setAvatarLink((String)avatar);
                                } else {
                                    LOG.warn((Object)("Cannot find call's owner space: " + ownerId));
                                    owner = new RoomInfo(ownerId, title);
                                    owner.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
                                }
                            } else if (isRoom) {
                                owner = new RoomInfo(ownerId, title);
                                owner.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
                            } else {
                                throw new CallArgumentException("Wrong call owner type: " + ownerType);
                            }
                            LinkedHashSet<UserInfo> participants = new LinkedHashSet<UserInfo>();
                            for (String pid : parts) {
                                if (WebConferencingService.isValidId(pid)) {
                                    UserInfo part = this.getUserInfo(pid);
                                    if (part != null) {
                                        participants.add(part);
                                        continue;
                                    }
                                    participants.add(new ParticipantInfo(providerType, pid));
                                    continue;
                                }
                                LOG.error((Object)("Cannot add call participant with too long ID: " + pid));
                                throw new CallArgumentException("Wrong participant ID (" + pid + ")");
                            }
                            CallInfo call = new CallInfo(id, title, owner, providerType);
                            call.addParticipants(participants);
                            call.setState("started");
                            call.setLastDate(Calendar.getInstance().getTime());
                            try {
                                this.participantsStorage.clear();
                                this.callStorage.clear();
                            }
                            catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                                LOG.warn((Object)("Call storage cleanup failed before creating call: " + call.getId()), e);
                            }
                            this.createCall(call);
                            if (isGroup) {
                                for (UserInfo part : call.getParticipants()) {
                                    if (!UserInfo.TYPE_NAME.equals(part.getType()) || currentUserId.equals(part.getId())) continue;
                                    this.fireUserCallStateChanged(part.getId(), id, providerType, "started", ownerId, ownerType);
                                }
                            } else if (isUser) {
                                this.notifyUserCallStateChanged(call, currentUserId, "started");
                            }
                            return call;
                        }
                        throw new CallArgumentException("Wrong call title");
                    }
                    throw new CallArgumentException("Wrong provider");
                }
                throw new CallArgumentException("Wrong owner type");
            }
            throw new CallArgumentException("Wrong owner ID value");
        }
        throw new CallArgumentException("Wrong call ID value");
    }

    public CallInfo getCall(String id) throws InvalidCallException {
        try {
            return this.findCallById(id);
        }
        catch (CallOwnerException | CallSettingsException | IdentityStateException | StorageException e) {
            throw new InvalidCallException("Error getting call: " + id, e);
        }
    }

    public CallInfo stopCall(String id, boolean remove) throws CallNotFoundException, InvalidCallException {
        CallInfo call = this.getCall(id);
        if (call != null) {
            String userId = this.currentUserId();
            try {
                this.stopCall(call, userId, remove);
                return call;
            }
            catch (StorageException e) {
                throw new InvalidCallException("Error stopping call: " + id, e);
            }
        }
        throw new CallNotFoundException("Call not found: " + id);
    }

    protected CallInfo stopCall(CallInfo call, String userId, boolean remove) throws StorageException {
        if (remove) {
            this.deleteCall(call.getId());
        } else {
            call.setState("stopped");
            try {
                this.updateCall(call);
            }
            catch (CallNotFoundException | CallSettingsException e) {
                LOG.warn((Object)("Failed to save stopped call: " + call.getId()), (Throwable)e);
            }
        }
        if (call.getOwner().isGroup()) {
            String callId = call.getId();
            for (UserInfo part : call.getParticipants()) {
                if (!UserInfo.TYPE_NAME.equals(part.getType()) || userId != null && remove && userId.equals(part.getId())) continue;
                this.fireUserCallStateChanged(part.getId(), callId, call.getProviderType(), "stopped", call.getOwner().getId(), call.getOwner().getType());
            }
        } else {
            this.notifyUserCallStateChanged(call, userId, "stopped");
        }
        return call;
    }

    public CallInfo startCall(String id, String clientId) throws CallNotFoundException, InvalidCallException {
        CallInfo call = this.getCall(id);
        if (call != null) {
            try {
                this.startCall(call, clientId);
                return call;
            }
            catch (CallSettingsException | ParticipantNotFoundException | StorageException e) {
                throw new InvalidCallException("Error starting call: " + id, e);
            }
        }
        throw new CallNotFoundException("Call not found: " + id);
    }

    protected void startCall(CallInfo call, String clientId) throws ParticipantNotFoundException, CallSettingsException, StorageException, CallNotFoundException {
        String callId = call.getId();
        call.setState("started");
        String userId = this.currentUserId();
        for (UserInfo part : call.getParticipants()) {
            if (UserInfo.TYPE_NAME.equals(part.getType()) && userId.equals(part.getId())) {
                part.setState("joined");
                part.setClientId(clientId);
                continue;
            }
            part.setState("leaved");
            part.setClientId(null);
        }
        this.updateCallAndParticipants(call);
        for (UserInfo part : call.getParticipants()) {
            this.fireUserCallStateChanged(part.getId(), callId, call.getProviderType(), "started", call.getOwner().getId(), call.getOwner().getType());
        }
    }

    public CallInfo joinCall(String id, String partId, String clientId) throws InvalidCallException, CallNotFoundException {
        CallInfo call = this.getCall(id);
        if (call != null) {
            try {
                if ("started".equals(call.getState())) {
                    UserInfo joined = null;
                    for (UserInfo part : call.getParticipants()) {
                        if (!UserInfo.TYPE_NAME.equals(part.getType()) || !partId.equals(part.getId())) continue;
                        part.setState("joined");
                        part.setClientId(clientId);
                        joined = part;
                        break;
                    }
                    if (joined != null) {
                        this.updateParticipant(id, joined);
                        for (UserInfo part : call.getParticipants()) {
                            this.fireUserCallJoined(id, call.getProviderType(), call.getOwner().getId(), call.getOwner().getType(), partId, part.getId());
                        }
                    }
                } else {
                    this.startCall(call, clientId);
                }
            }
            catch (CallSettingsException | ParticipantNotFoundException | StorageException e) {
                throw new InvalidCallException("Error joining call: " + id, e);
            }
            return call;
        }
        throw new CallNotFoundException("Call not found: " + id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallInfo leaveCall(String id, String partId, String clientId) throws InvalidCallException {
        CallInfo call = this.getCall(id);
        if (call != null) {
            try {
                if (!"started".equals(call.getState()) && !"paused".equals(call.getState())) return call;
                UserInfo leaved = null;
                int leavedNum = 0;
                for (UserInfo part : call.getParticipants()) {
                    if (!UserInfo.TYPE_NAME.equals(part.getType())) continue;
                    if (partId.equals(part.getId())) {
                        if (!part.hasSameClientId(clientId)) continue;
                        part.setState("leaved");
                        part.setClientId(null);
                        leaved = part;
                        ++leavedNum;
                        continue;
                    }
                    if (part.getState() != null && !part.getState().equals("leaved")) continue;
                    ++leavedNum;
                }
                if (leaved == null) return call;
                this.updateParticipant(id, leaved);
                for (UserInfo part : call.getParticipants()) {
                    this.fireUserCallLeaved(id, call.getProviderType(), call.getOwner().getId(), call.getOwner().getType(), partId, part.getId());
                }
                if (call.getOwner().isGroup()) {
                    if (leavedNum != call.getParticipants().size()) return call;
                    this.stopCall(call, partId, false);
                    return call;
                }
                if (call.getParticipants().size() - leavedNum > 1) return call;
                this.stopCall(call, partId, true);
                return call;
            }
            catch (ParticipantNotFoundException | StorageException e) {
                throw new InvalidCallException("Error leaving call: " + id, e);
            }
        } else {
            LOG.warn((Object)("Call " + id + " not found to leave it " + partId));
        }
        return call;
    }

    public CallState[] getUserCalls(String userId) throws StorageException {
        CallState[] states = (CallState[])this.findUserGroupCalls(userId).stream().map(c -> new CallState(c.getId(), c.getState() != null ? c.getState() : "stopped")).toArray(CallState[]::new);
        return states;
    }

    public void addUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        this.userListeners.computeIfAbsent(userId, k -> new LinkedHashSet()).add(listener);
    }

    public void removeUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    protected void fireUserCallStateChanged(String userId, String callId, String providerType, String callState, String ownerId, String ownerType) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onCallStateChanged(callId, providerType, callState, ownerId, ownerType);
            }
        }
    }

    protected void fireUserCallJoined(String callId, String providerType, String ownerId, String ownerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onPartJoined(callId, providerType, ownerId, ownerType, partId);
            }
        }
    }

    protected void fireUserCallLeaved(String callId, String providerType, String ownerId, String ownerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onPartLeaved(callId, providerType, ownerId, ownerType, partId);
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        Class<CallProvider> pclass = CallProvider.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            this.addProvider((CallProvider)((Object)pclass.cast(plugin)));
        } else {
            LOG.warn((Object)("Web Conferencing provider plugin is not an instance of " + pclass.getName() + ". Skipped plugin: " + plugin));
        }
    }

    public void addProvider(CallProvider provider) {
        for (String type : provider.getSupportedTypes()) {
            CallProvider existing = this.providers.putIfAbsent(type, provider);
            if (existing == null) continue;
            LOG.warn((Object)("Web Conferencing provider type '" + existing.getType() + "' already registered. Skipped plugin: " + (Object)((Object)provider)));
        }
    }

    public CallProvider getProvider(String type) {
        CallProvider p = this.providers.get(type);
        if (p != null) {
            try {
                CallProviderConfiguration conf = this.readProviderConfig(p.getType());
                if (conf != null) {
                    p.setActive(conf.isActive());
                } else {
                    p.setActive(true);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading provider configuration " + p.getType()), (Throwable)e);
                p.setActive(true);
            }
        }
        return p;
    }

    public Set<CallProviderConfiguration> getProviderConfigurations(Locale locale) {
        LinkedHashSet<CallProvider> allProviders = new LinkedHashSet<CallProvider>();
        for (CallProvider registeredProvider : this.providers.values()) {
            allProviders.add(registeredProvider);
        }
        LinkedHashSet<CallProviderConfiguration> allConfs = new LinkedHashSet<CallProviderConfiguration>();
        for (CallProvider p : allProviders) {
            boolean addDefault = false;
            try {
                CallProviderConfiguration conf = this.readProviderConfig(p.getType());
                if (conf != null) {
                    conf.setTitle(p.getTitle());
                    conf.setDescription(p.getDescription(locale));
                    conf.setLogEnabled(p.isLogEnabled());
                    allConfs.add(conf);
                } else {
                    addDefault = true;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading providers configuration " + p.getType()), (Throwable)e);
                addDefault = true;
            }
            if (!addDefault) continue;
            CallProviderConfiguration defaultConf = CallProviderConfiguration.fromProvider(p, locale);
            allConfs.add(defaultConf);
        }
        return allConfs;
    }

    public Set<CallProviderConfiguration> getProviderConfigurations() {
        return this.getProviderConfigurations(Locale.getDefault());
    }

    public CallProviderConfiguration getProviderConfiguration(String providerType, Locale locale) {
        CallProvider p = this.getProvider(providerType);
        if (p != null) {
            CallProviderConfiguration conf = this.readProviderConfig(p.getType());
            if (conf == null) {
                conf = CallProviderConfiguration.fromProvider(p, locale);
            } else {
                conf.setTitle(p.getTitle());
                conf.setDescription(p.getDescription(locale));
                conf.setLogEnabled(p.isLogEnabled());
            }
            return conf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProviderConfiguration(CallProviderConfiguration conf) throws UnsupportedEncodingException, JSONException {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            JSONObject json = this.providerConfigToJson(conf);
            String safeType = URLEncoder.encode(conf.getType(), "UTF-8");
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), safeType, SettingValue.create((String)json.toString()));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    public void start() {
        this.spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        LOG.info((Object)"Web Conferencing service started.");
        try {
            int cleaned = this.deleteAllUserCalls();
            if (cleaned > 0) {
                LOG.info((Object)("Cleaned " + cleaned + " expired user calls."));
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)"Error cleaning calls from previous server execution", e);
        }
    }

    public void stop() {
    }

    protected boolean isSpaceMember(String userName, String spacePrettyName) {
        return this.getSpaceMembers(spacePrettyName).contains(userName);
    }

    protected Set<String> getSpaceMembers(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        HashSet<String> spaceMembers = new HashSet<String>();
        for (String sm : space.getMembers()) {
            spaceMembers.add(sm);
        }
        return spaceMembers;
    }

    protected CallProviderConfiguration jsonToProviderConfig(JSONObject json) throws JSONException {
        String type = json.getString("type");
        boolean active = json.getBoolean("active");
        CallProviderConfiguration conf = new CallProviderConfiguration();
        conf.setActive(active);
        conf.setType(type);
        return conf;
    }

    protected JSONObject providerConfigToJson(CallProviderConfiguration conf) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("type", (Object)conf.getType());
        json.put("active", conf.isActive());
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallProviderConfiguration readProviderConfig(String type) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            String safeType = URLEncoder.encode(type, "UTF-8");
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), safeType);
            if (val != null) {
                String str = String.valueOf(val.getValue());
                if (str.startsWith("{")) {
                    CallProviderConfiguration conf;
                    CallProviderConfiguration callProviderConfiguration = conf = this.jsonToProviderConfig(new JSONObject(str));
                    return callProviderConfiguration;
                }
                LOG.warn((Object)("Cannot parse saved CallProviderConfiguration: " + str));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)"UTF8 encoding required to read provider config", (Throwable)e);
        }
        catch (JSONException e) {
            LOG.warn((Object)"Error reading provider config", (Throwable)e);
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
        return null;
    }

    protected String currentUserId() {
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null) {
            return contextState.getIdentity().getUserId();
        }
        return null;
    }

    protected void notifyUserCallStateChanged(CallInfo call, String initiatorId, String state) {
        for (UserInfo part : call.getParticipants()) {
            if (!UserInfo.TYPE_NAME.equals(part.getType()) || initiatorId != null && initiatorId.equals(part.getId()) && !"stopped".equals(state)) continue;
            this.fireUserCallStateChanged(part.getId(), call.getId(), call.getProviderType(), state, call.getOwner().getId(), call.getOwner().getType());
        }
    }

    protected CallInfo readCallEntity(CallEntity savedCall, boolean withParticipants) throws CallSettingsException, IdentityStateException, CallOwnerException {
        if (savedCall != null) {
            IdentityInfo owner;
            String ownerId = savedCall.getOwnerId();
            if (OWNER_TYPE_CHATROOM.equals(savedCall.getOwnerType())) {
                String settings = savedCall.getSettings();
                try {
                    JSONObject json = new JSONObject(settings);
                    String roomTitle = json.optString("roomTitle");
                    if (roomTitle == null || roomTitle.length() <= 0) {
                        LOG.warn((Object)("Saved call doesn't have room settings: '" + settings + "'"));
                        throw new CallSettingsException("Saved call doesn't have room settings");
                    }
                    owner = this.roomInfo(ownerId, roomTitle, new String[0], savedCall.getId());
                }
                catch (JSONException e) {
                    LOG.warn((Object)("Saved call has wrong room settings format (bad JSON syntax): '" + settings + "'"), (Throwable)e);
                    throw new CallSettingsException("Saved call has wrong room settings format", e);
                }
            } else if (OWNER_TYPE_SPACE.equals(savedCall.getOwnerType())) {
                owner = this.spaceInfo(ownerId, savedCall.getId());
            } else if (UserInfo.TYPE_NAME.equals(savedCall.getOwnerType())) {
                owner = this.getUserInfo(ownerId);
            } else {
                throw new CallOwnerException("Unexpected call owner type: " + savedCall.getOwnerType() + " for " + ownerId);
            }
            String callId = savedCall.getId();
            CallInfo call = new CallInfo(callId, savedCall.getTitle(), owner, savedCall.getProviderType());
            call.setState(savedCall.getState());
            call.setLastDate(savedCall.getLastDate());
            if (withParticipants) {
                for (ParticipantEntity p : this.participantsStorage.findCallParts(callId)) {
                    if (UserInfo.TYPE_NAME.equals(p.getType())) {
                        UserInfo user = this.getUserInfo(p.getId());
                        if (user == null) {
                            user = new ParticipantInfo(call.getProviderType(), p.getId());
                        }
                        user.setState(p.getState());
                        user.setClientId(p.getClientId());
                        call.addParticipant(user);
                        continue;
                    }
                    LOG.warn((Object)("Non user participant skipped for call " + callId + ": " + p.getId() + " (" + p.getType() + ")"));
                }
            }
            return call;
        }
        return null;
    }

    protected CallEntity createCallEntity(CallInfo call) throws CallSettingsException {
        CallEntity entity = new CallEntity();
        this.syncCallEntity(call, entity);
        return entity;
    }

    protected void syncCallEntity(CallInfo call, CallEntity entity) throws CallSettingsException {
        if (call != null) {
            String callId = call.getId();
            entity.setId(callId);
            entity.setProviderType(call.getProviderType());
            entity.setTitle(call.getTitle());
            IdentityInfo owner = call.getOwner();
            entity.setOwnerId(owner.getId());
            entity.setOwnerType(owner.getType());
            entity.setState(call.getState());
            entity.setLastDate(call.getLastDate());
            if (OWNER_TYPE_CHATROOM.equals(owner.getType())) {
                entity.setIsGroup(true);
                entity.setIsUser(false);
                RoomInfo room = (RoomInfo)RoomInfo.class.cast(owner);
                try {
                    JSONObject json = new JSONObject();
                    json.put("roomTitle", (Object)room.getTitle());
                    String settings = json.toString();
                    if (!WebConferencingService.isValidData(settings)) {
                        LOG.warn((Object)("Call settings too long: '" + settings + "'. Max value is " + 2000 + " bytes in UTF8 encoding."));
                        throw new CallSettingsException("Call settings too long (room title)");
                    }
                    entity.setSettings(settings);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CallSettingsException("Cannot save call settings (UTF8 encoding required)", e);
                }
                catch (JSONException e) {
                    throw new CallSettingsException("Cannot save call settings (title should be a text)", e);
                }
            } else if (OWNER_TYPE_SPACE.equals(owner.getType())) {
                entity.setIsGroup(true);
                entity.setIsUser(false);
            } else {
                entity.setIsGroup(false);
                entity.setIsUser(true);
            }
        } else {
            throw new NullPointerException("Call info is null");
        }
    }

    protected ParticipantEntity createParticipantEntity(String callId, UserInfo user) {
        ParticipantEntity part = new ParticipantEntity();
        part.setId(user.getId());
        part.setCallId(callId);
        part.setType(user.getType());
        part.setState(user.getState());
        part.setClientId(user.getClientId());
        return part;
    }

    protected <C extends SQLException> C exceptionCause(PersistenceException pe, Class<C> causeClass) {
        Throwable c;
        PersistenceException e = pe;
        do {
            if (e == null || !causeClass.isAssignableFrom(((Object)((Object)e)).getClass())) continue;
            return (C)((SQLException)causeClass.cast((Object)e));
        } while ((e = (c = e.getCause()) != null && c != e ? c : null) != null);
        return null;
    }

    @ExoTransactional
    protected void txCreateCall(CallInfo call) throws IllegalArgumentException, IllegalStateException, PersistenceException, CallSettingsException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void saveCall(CallInfo call) throws CallNotFoundException, IllegalArgumentException, IllegalStateException, PersistenceException, CallSettingsException {
        CallEntity entity = (CallEntity)this.callStorage.find((Serializable)((Object)call.getId()));
        if (entity == null) {
            throw new CallNotFoundException("Call not found: " + call.getId());
        }
        this.syncCallEntity(call, entity);
        this.callStorage.update(entity);
    }

    @ExoTransactional
    protected void txUpdateCall(CallInfo call) throws CallNotFoundException, IllegalArgumentException, IllegalStateException, PersistenceException, CallSettingsException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void saveParticipant(String callId, UserInfo participant) throws IllegalArgumentException, IllegalStateException, PersistenceException, ParticipantNotFoundException {
        ParticipantEntity part = (ParticipantEntity)this.participantsStorage.find(new ParticipantId(participant.getId(), callId));
        if (part == null) {
            throw new ParticipantNotFoundException("Call participant " + participant.getId() + " not found for " + callId);
        }
        part.setState(participant.getState());
        part.setClientId(participant.getClientId());
        this.participantsStorage.update(part);
    }

    @ExoTransactional
    protected void txUpdateParticipant(String callId, UserInfo participant) throws IllegalArgumentException, IllegalStateException, PersistenceException, ParticipantNotFoundException {
        String string = callId;
        UserInfo userInfo = participant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)userInfo);
        Object[] objectArray = new Object[]{this, string, userInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txUpdateCallAndParticipants(CallInfo call) throws IllegalArgumentException, IllegalStateException, PersistenceException, CallNotFoundException, CallSettingsException, ParticipantNotFoundException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected boolean txDeleteCall(String id) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    protected int txDeleteAllUserCalls() throws IllegalArgumentException, IllegalStateException, PersistenceException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    protected boolean deleteCall(String id) throws StorageException {
        try {
            return this.txDeleteCall(id);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error deleting call " + id, e);
        }
    }

    protected int deleteAllUserCalls() throws StorageException {
        try {
            return this.txDeleteAllUserCalls();
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error deleting all user calls", e);
        }
    }

    protected void updateCallAndParticipants(CallInfo call) throws StorageException, ParticipantNotFoundException, CallSettingsException, CallNotFoundException {
        try {
            this.txUpdateCallAndParticipants(call);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating call and participants: " + call.getId(), e);
        }
    }

    protected void updateParticipant(String callId, UserInfo participant) throws ParticipantNotFoundException, StorageException {
        try {
            this.txUpdateParticipant(callId, participant);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating participant " + participant.getId() + " of call " + callId, e);
        }
    }

    protected void updateCall(CallInfo call) throws CallNotFoundException, CallSettingsException, StorageException {
        try {
            this.txUpdateCall(call);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating call " + call.getId(), e);
        }
    }

    protected CallInfo findCallById(String id) throws IdentityStateException, StorageException, CallSettingsException, CallOwnerException {
        try {
            CallEntity savedCall = (CallEntity)this.callStorage.find((Serializable)((Object)id));
            return this.readCallEntity(savedCall, true);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading call " + id, e);
        }
    }

    protected String findGroupCallId(String ownerId) throws StorageException {
        try {
            CallEntity savedCall = this.callStorage.findGroupCallByOwnerId(ownerId);
            if (savedCall != null) {
                return savedCall.getId();
            }
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading owner group call ID by " + ownerId, e);
        }
    }

    protected Collection<CallInfo> findUserGroupCalls(String userId) throws StorageException {
        try {
            List<CallEntity> savedCalls = this.callStorage.findUserGroupCalls(userId);
            ArrayList<CallInfo> calls = new ArrayList<CallInfo>();
            for (CallEntity c : savedCalls) {
                try {
                    calls.add(this.readCallEntity(c, false));
                }
                catch (CallInfoException | IdentityStateException e) {
                    LOG.warn((Object)("Error reading user group call: " + c.getId()), (Throwable)e);
                }
            }
            return Collections.unmodifiableCollection(calls);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading user group calls by " + userId, e);
        }
    }

    protected void createCall(CallInfo call) throws StorageException, CallConflictException, CallSettingsException {
        try {
            this.txCreateCall(call);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new StorageException("Error creating call " + call.getId(), e);
        }
        catch (PersistenceException pe) {
            SQLIntegrityConstraintViolationException constEx = this.exceptionCause(pe, SQLIntegrityConstraintViolationException.class);
            if (constEx != null && constEx.getMessage().indexOf("PK_WBC_CALLID") >= 0) {
                CallEntity conflictedCallEntity = (CallEntity)this.callStorage.find((Serializable)((Object)call.getId()));
                if (conflictedCallEntity != null) {
                    if ("started".equals(call.getState())) {
                        for (UserInfo savedPart : call.getParticipants()) {
                            Set<UserCallListener> ulisteners = this.userListeners.get(savedPart.getId());
                            if (ulisteners == null) continue;
                            for (UserCallListener ul : ulisteners) {
                                if (!savedPart.hasSameClientId(ul.getClientId())) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Call already started and running: " + call.getId()), (Throwable)pe);
                                }
                                throw new CallConflictException("Call already started and running");
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Call already started: " + call.getId()), (Throwable)pe);
                        }
                        throw new CallConflictException("Call already started");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Call already created with state " + conflictedCallEntity.getState() + ": " + call.getId()), (Throwable)pe);
                    }
                    throw new CallConflictException("Call already created");
                }
                LOG.warn((Object)("Call ID already found but cannot read the call: " + call.getId()), (Throwable)pe);
                throw new CallConflictException("Call ID already found", pe);
            }
            LOG.error((Object)("Error creating call: " + call.getId()), (Throwable)pe);
            throw new StorageException("Error creating call", pe);
        }
    }

    protected void invalidateCall(String id, boolean isGroup) throws CallConflictException, StorageException {
        block8: {
            try {
                CallEntity existingCallEntity = (CallEntity)this.callStorage.find((Serializable)((Object)id));
                if (existingCallEntity == null) break block8;
                if (isGroup) {
                    throw new CallConflictException("Call already created");
                }
                try {
                    CallInfo existingCall = this.readCallEntity(existingCallEntity, true);
                    if ("started".equals(existingCall.getState())) {
                        for (UserInfo savedPart : existingCall.getParticipants()) {
                            Set<UserCallListener> ulisteners = this.userListeners.get(savedPart.getId());
                            if (ulisteners == null) continue;
                            for (UserCallListener ul : ulisteners) {
                                if (!savedPart.hasSameClientId(ul.getClientId())) continue;
                                throw new CallConflictException("Call already started");
                            }
                        }
                        this.deleteCall(id);
                        LOG.warn((Object)("Deleted not active call: " + id));
                        break block8;
                    }
                    this.deleteCall(id);
                    LOG.warn((Object)("Deleted outdated call: " + id));
                }
                catch (CallInfoException | IdentityStateException e) {
                    LOG.warn((Object)("Call in erroneous state: " + id), (Throwable)e);
                    this.deleteCall(id);
                    LOG.warn((Object)("Deleted erroneous call: " + id));
                }
            }
            catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                LOG.warn((Object)("Error reading call by ID: " + id), e);
            }
        }
    }

    static {
        WebConferencingService.ajc$preClinit();
        SPACE_TYPE_NAME = OWNER_TYPE_SPACE.intern();
        CHAT_ROOM_TYPE_NAME = OWNER_TYPE_CHATROOM.intern();
        GROUP_CALL_TYPE = "group".intern();
        CALL_OWNER_SCOPE_NAME = "webconferencing.callOwner".intern();
        CALL_ID_SCOPE_NAME = "webconferencing.callId".intern();
        USER_CALLS_SCOPE_NAME = "webconferencing.user.calls".intern();
        PROVIDER_SCOPE_NAME = "webconferencing.provider".intern();
        LOG = ExoLogger.getLogger(WebConferencingService.class);
    }

    static /* synthetic */ void txCreateCall_aroundBody0(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        ajc$this.callStorage.create(ajc$this.createCallEntity(call));
        String callId = call.getId();
        for (UserInfo p : call.getParticipants()) {
            ajc$this.participantsStorage.create(ajc$this.createParticipantEntity(callId, p));
        }
    }

    static /* synthetic */ void txUpdateCall_aroundBody2(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        ajc$this.saveCall(call);
    }

    static /* synthetic */ void txUpdateParticipant_aroundBody4(WebConferencingService ajc$this, String callId, UserInfo participant, JoinPoint joinPoint) {
        ajc$this.saveParticipant(callId, participant);
    }

    static /* synthetic */ void txUpdateCallAndParticipants_aroundBody6(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        ajc$this.saveCall(call);
        String callId = call.getId();
        for (UserInfo p : call.getParticipants()) {
            ajc$this.saveParticipant(callId, p);
        }
    }

    static /* synthetic */ boolean txDeleteCall_aroundBody8(WebConferencingService ajc$this, String id, JoinPoint joinPoint) {
        CallEntity entity = (CallEntity)ajc$this.callStorage.find((Serializable)((Object)id));
        if (entity != null) {
            ajc$this.callStorage.delete(entity);
            return true;
        }
        return false;
    }

    static /* synthetic */ int txDeleteAllUserCalls_aroundBody10(WebConferencingService ajc$this, JoinPoint joinPoint) {
        return ajc$this.callStorage.deleteAllUsersCalls();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebConferencingService.java", WebConferencingService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txCreateCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallSettingsException", "void"), 1496);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "org.exoplatform.webconferencing.CallNotFoundException:java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallSettingsException", "void"), 1544);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateParticipant", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String:org.exoplatform.webconferencing.UserInfo", "callId:participant", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.ParticipantNotFoundException", "void"), 1588);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateCallAndParticipants", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallNotFoundException:org.exoplatform.webconferencing.CallSettingsException:org.exoplatform.webconferencing.ParticipantNotFoundException", "void"), 1610);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txDeleteCall", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String", "id", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "boolean"), 1633);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txDeleteAllUserCalls", "org.exoplatform.webconferencing.WebConferencingService", "", "", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "int"), 1652);
    }

    public class RoomInfo
    extends GroupInfo {
        public RoomInfo(String id, String title) {
            super(id, title);
            this.profileLink = IdentityInfo.EMPTY;
        }

        @Override
        public String getType() {
            return CHAT_ROOM_TYPE_NAME;
        }
    }

    public class SpaceInfo
    extends GroupInfo {
        protected final String groupId;

        public SpaceInfo(Space socialSpace) {
            super(socialSpace.getPrettyName(), socialSpace.getDisplayName());
            this.groupId = socialSpace.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getType() {
            return SPACE_TYPE_NAME;
        }
    }
}

