/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.rest;

import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webconferencing.CallProviderConfiguration;
import org.exoplatform.webconferencing.IdentityStateException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.client.ErrorInfo;
import org.exoplatform.webconferencing.dao.StorageException;

@Path(value="/webconferencing")
@Produces(value={"application/json"})
public class RESTWebConferencingService
implements ResourceContainer {
    public static final String EMPTY = "".intern();
    protected static final Log LOG = ExoLogger.getLogger(RESTWebConferencingService.class);
    protected final WebConferencingService webConferencing;
    private final CacheControl cacheControl;

    public RESTWebConferencingService(WebConferencingService webConferencing) {
        this.webConferencing = webConferencing;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/provider/{type}/configuration")
    public Response getProviderConfig(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="type") String type) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallProviderConfiguration conf = this.webConferencing.getProviderConfiguration(type, request.getLocale());
                if (conf != null) {
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)conf).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Provider or configuration not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading provider configuration for '" + type + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading provider configuration")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="/provider/{type}/configuration")
    public Response postProviderConfig(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="type") String type, @FormParam(value="active") String active) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallProviderConfiguration conf = this.webConferencing.getProviderConfiguration(type, request.getLocale());
                if (conf != null) {
                    boolean activeVal = Boolean.valueOf(active);
                    if (activeVal != conf.isActive()) {
                        conf.setActive(activeVal);
                        this.webConferencing.saveProviderConfiguration(conf);
                    }
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)conf).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Provider or configuration not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error saving provider configuration for '" + type + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error saving provider configuration")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/providers/configuration")
    public Response getProviderConfigs(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                Set<CallProviderConfiguration> confs = this.webConferencing.getProviderConfigurations(request.getLocale());
                return Response.ok().cacheControl(this.cacheControl).entity(confs).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading providers configuration by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading providers configuration")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}")
    public Response getUserInfo(@Context UriInfo uriInfo, @PathParam(value="name") String userName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                try {
                    UserInfo user = this.webConferencing.getUserInfo(userName);
                    if (user != null) {
                        return Response.ok().cacheControl(this.cacheControl).entity((Object)user).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("User not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading user info of '" + userName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading user " + userName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space/{spaceName}")
    public Response getSpaceInfo(@Context UriInfo uriInfo, @PathParam(value="spaceName") String spaceName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceName != null && spaceName.length() > 0) {
                try {
                    WebConferencingService.SpaceInfo space = this.webConferencing.getSpaceInfo(spaceName);
                    if (space != null) {
                        if (space.getMembers().containsKey(currentUserName)) {
                            return Response.ok().cacheControl(this.cacheControl).entity((Object)space).build();
                        }
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not space member")).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                }
                catch (IdentityStateException e) {
                    LOG.error((Object)("Error reading member of space '" + spaceName + "' by '" + currentUserName + "'"), (Throwable)e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading member of space '" + spaceName + "'")).build();
                }
                catch (StorageException e) {
                    LOG.error((Object)("Storage error for space info of '" + spaceName + "' by '" + currentUserName + "'"), (Throwable)e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Storage error for space '" + spaceName + "'")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading space info of '" + spaceName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading space " + spaceName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space-event/{spaceName}")
    public Response getSpaceEventInfo(@Context UriInfo uriInfo, @PathParam(value="spaceName") String spaceName, @QueryParam(value="participants") String participants, @QueryParam(value="spaces") String spaces) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceName != null && spaceName.length() > 0) {
                if (participants != null && participants.length() > 0) {
                    if (spaces != null && spaces.length() > 0) {
                        try {
                            WebConferencingService.SpaceEventInfo space = this.webConferencing.getSpaceEventInfo(spaceName, participants.trim().split(";"), spaces.trim().split(";"));
                            if (space != null) {
                                if (space.getMembers().containsKey(currentUserName)) {
                                    return Response.ok().cacheControl(this.cacheControl).entity((Object)space).build();
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not space member")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                        }
                        catch (IdentityStateException e) {
                            LOG.error((Object)("Error reading member of space '" + spaceName + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading member of space '" + spaceName + "'")).build();
                        }
                        catch (StorageException e) {
                            LOG.error((Object)("Storage error for space event info of '" + spaceName + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Storage error for space '" + spaceName + "'")).build();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error reading space event info of '" + spaceName + "' by '" + currentUserName + "'"), e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading space " + spaceName)).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: spaces")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: participants")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: spaceName")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/room/{id}")
    public Response getRoomInfo(@Context UriInfo uriInfo, @PathParam(value="id") String roomId, @QueryParam(value="title") String roomTitle, @QueryParam(value="members") String roomMembers) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (roomId != null && roomId.length() > 0) {
                if (roomTitle != null && roomTitle.length() > 0) {
                    if (roomMembers != null && roomMembers.length() > 0) {
                        try {
                            WebConferencingService.RoomInfo room = this.webConferencing.getRoomInfo(roomId, roomTitle, roomMembers.trim().split(";"));
                            if (room != null) {
                                if (room.getMembers().containsKey(currentUserName)) {
                                    return Response.ok().cacheControl(this.cacheControl).entity((Object)room).build();
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not room member")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Room not found or not accessible")).build();
                        }
                        catch (IdentityStateException e) {
                            LOG.error((Object)("Error reading member of room '" + roomTitle + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading member of room '" + roomTitle + "'")).build();
                        }
                        catch (StorageException e) {
                            LOG.error((Object)("Storage error for room info of '" + roomTitle + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Storage error for room '" + roomTitle + "'")).build();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error reading room info of '" + roomTitle + "' by '" + currentUserName + "'"), e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading room '" + roomTitle + "'")).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: members")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: title")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: id")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }
}

